import { createRouter, createWebHistory, RouteRecordRaw } from 'vue-router'
import { getLocalStorage } from '@/hooks/useLocalStorage'

const routes: Array<RouteRecordRaw> = [
  {
    path: '/',
    redirect: '/Container'
  },
  {
    path: "/:pathMatch(.*)*",
    component: () => import(/* webpackChunkName: "ErrorPage" */ '../views/ErrorPage/index.vue'),
    name: 'notFound'
  },
  {
    path: '/container',
    name: 'Container',
    redirect: '/Notice', // 子路有重定向
    component: () => import(/* webpackChunkName: "Container" */ '../views/Container/index.vue'),
    children: [
      {
        path: '/guide',
        name: 'Guide',
        component: () => import(/* webpackChunkName: "Guide" */ '../views/Guide/index.vue'),
      },
      {
        path: '/AccountSetting',
        name: 'AccountSetting',
        component: () => import(/* webpackChunkName: "AccountSetting" */ '../views/AccountSetting/index.vue')
      },
      {
        path: '/AnalysisSetup',
        name: 'AnalysisSetup',
        component: () => import(/* webpackChunkName: "AnalysisSetup" */ '../views/AnalysisSetup/index.vue')
      },
      {
        path: '/Approve',
        name: 'Approve',
        component: () => import(/* webpackChunkName: "Approve" */ '../views/Approve/index.vue')
      },
      {
        path: '/ManageDataset',
        name: 'ManageDataset',
        component: () => import(/* webpackChunkName: "ManageDataset" */ '../views/ManageDataset/index.vue')
      },
      {
        path: '/ManageUser',
        name: 'ManageUser',
        component: () => import(/* webpackChunkName: "ManageMember" */ '../views/ManageUser/index.vue')
      },
      {
        path: '/Notice',
        name: 'Notice',
        component: () => import(/* webpackChunkName: "Notice" */ '../views/Notice/index.vue')
      },
      {
        path: '/SaveResult',
        name: 'SaveResult',
        component: () => import(/* webpackChunkName: "SaveResult" */ '../views/SaveResult/index.vue')
      }
    ]
  },
  {
    path: '/login',
    name: 'Login',
    component: () => import(/* webpackChunkName: "Login" */ '../views/Login/index.vue')
  }
]

const router = createRouter({
  // vue-cli
  // history: createWebHistory(process.env.BASE_URL),
  // vite
  history: createWebHistory(import.meta.env.BASE_URL),
  routes
})

router.beforeEach((to, from, next) => {
  // 测试用
  let isLogin: string | null | boolean = getLocalStorage('isLogin')
  // 暂时使用 硬编码。
  // const isLogin = false

  if (to.path === '/login') { // 判断是否进入的login页
    if (isLogin) { // 判断是否登陆
      next({ path: from.path })  // 已登录，跳转回源页面
    } else {
      next()  // 没登录，继续进入login页
    }
  } else { // 如果进入的非login页
    if (isLogin) { // 同样判断是否登陆
      next()  // 已登录，正常进入
    } else {
      next({ path: '/login'})  // 没登录，跳转到login页
    }
  }
})

export default router
