import useDirective from '@/hooks/useDirective'
import router from '@/router'
import { createApp } from 'vue'
import { createPinia } from 'pinia'
import App from './App.vue'
import * as Icons from '@element-plus/icons-vue'
import ElementPlus from 'element-plus'
import 'element-plus/dist/index.css'
import '@/echarts'

// 创建实例
const app = createApp(App)

app.use(ElementPlus)
// 使用hook生成自定义指令
useDirective(app)

// 注册全局icon组件 否则使用动态组件 icon不会显示
Object.keys(Icons).forEach(key => {
  app.component(key, Icons[key as keyof typeof Icons])
})

app.use(createPinia()).use(router).mount('#app')
