interface Common {
  code?: number
}

interface Login {
  success: boolean,
  data: string,
  errMsg: string
}

interface GetLoginUser {
  success: boolean,
  data: {
    userId: number | string,
    userName: string,
    occupiedSpace: number | string,
    otherInfo: null | string,
    roleId: number | string,
    roleName: string,
    menuList: string[]
  },
  errMsg: string
}

interface CreateUser {
  success: boolean,
  data: string,
  errMsg: string
}

interface UpdateUser {
  success: boolean,
  data: string,
  errMsg: string
}

interface DeleteUser {
  success: boolean,
  data: string,
  errMsg: string
}

interface GetMemberPageList {
  success: true,
  data: {
    content: {
      'py/object': string,
      userId: number | string,
      userName: string,
      occupiedSpace: number | string,
      otherInfo: null | number | string,
      roleId: number,
      roleName: string,
      menuList: string[]
    }[],
    pageIndex: number | string,
    pageSize: number | string,
    totalCount: number | string
  },
  errMsg: string
}
interface GetNoticePageList {
  success: true,
  data: {
    content: {
      'py/object': string,
      userId: number,
      userName: string,
      content: string,
      readFlag: boolean
    }[],
    pageIndex: 1,
    pageSize: 10,
    totalCount: 1
  },
  errMsg: string
}

interface GetApplyPageList {
  success: true,
  data: {
    content: {
      'py/object': string,
      applyFormId: string,
      userId: number | string,
      userName: string,
      reason: string,
      statusId: number | string,
      statusName: string,
      createDateTime: string
    }[],
    pageIndex: number | string,
    pageSize: number | string,
    totalCount: number | string
  },
  errMsg: string
}
interface Apply {
  success: true,
  data: string,
  errMsg: string
}
interface Approve {
  success: true,
  data: string,
  errMsg: string
}
interface GetFilePageList {
  success: true,
  data: {
    content: {
      id: number | string,
      fileName: string,
      filePath: string,
      fileUrl: string,
      fileSize: number | string
    }[],
    pageIndex: number,
    pageSize: number,
    totalCount: number
  },
  errMsg: string
}
interface Upload {
  success: true,
  data: string,
  errMsg: string
}
interface BatchUpload {
  'py/object': string,
  success: true,
  data: {
    'py/object': string,
    url: string,
    result: string
  }[],
  errMsg: string
}
interface Download {
  'py/object': string,
  success: true,
  data: string,
  errMsg: string
}
interface Delete {
  'py/object': string,
  success: true,
  data: string,
  errMsg: string
}
interface GetSetupPageList {
  success: boolean,
  data: {
    content: {
      setupId: string,
      setupName: string,
      createUserId: number | string,
      createUserName: string,
      createDateTime: string
    }[],
    pageIndex: number,
    pageSize: number,
    totalCount: number
  },
  errMsg: string
}

type measureItem = 'Can Open' | 'Com-I-DevA' | 'Com-I-5' | 'Acc-I-4' | 'Con-I-3' | 'Con-I-2-DevB' | 'Con-I-4-DevC' | 'Error'
interface GetDetail {
  success: boolean,
  data: {
    setupId: string,
    setupName: string,
    createUserId: number |string,
    createUserName: string,
    createDateTime: string,
    selectAll: string | boolean,
    fileList: {
      id: string | number,
      fileName: string,
      filePath: string,
      fileUrl: string,
      fileSize: string | number
    }[],
    measureList: measureItem[]
},
  errMsg: string
}
interface Analysis {
  success: boolean,
    data: {
      resultByDataset: {
        fileId: number | string,
        fileName: string,
        measureList: {
          'py/object': string,
          measure: string,
          value: string | number
        }[]
      }[],
      resultByMeasure: {
        measure: string,
        datasetList: {
          'py/object': string,
          fileId: number | string,
          fileName: string,
          value: string | number
        }[]
      }[]
  },
  errMsg: null
}
interface Save {
  success: boolean,
  data: string,
  errMsg: null
}
interface SetupDelete {
  success: boolean,
  data: string,
  errMsg: null
}
interface ResultSave {
  success: boolean,
  data: string,
  errMsg: null
}
interface GetAnalysisResultPageList {
  success: boolean,
  data: {
    'py/object': string,
    content: {
      'py/object': string,
      resultId: string,
      resultName: string,
      createUserId: number | string,
      createUserName: string,
      createDateTime: string
    }[],
    pageIndex: number,
    pageSize: number,
    totalCount: number
  },
  errMsg: null
}
interface ResultDelete {
  success: boolean,
  data: string,
  errMsg: null
}
interface Rename {
  success: boolean,
  data: string,
  errMsg: null
}
interface ResultGetDetail {
  'py/object': string,
  success: true,
  data: {
    fileList: {
      id: number | string,
      fileName: string,
      filePath: string,
      fileUrl: string,
      fileSize: string | number
    }[],
    resultByDateset: {
      fileId: number | string,
      fileName: string,
      measureList: {
        measure: string,
        value: string | number
      }[]
    }[],
    resultByMeasure: {
      measure: string,
      datasetList: {
        fileId: number | string,
        fileName: string,
        value: number | string
      }[]
    }[]
  },
  errMsg: string
}

// interface
export {
  Login,
  GetLoginUser,
  CreateUser,
  UpdateUser,
  DeleteUser,
  GetMemberPageList,
  GetNoticePageList,
  GetApplyPageList,
  Apply,
  Approve,
  GetFilePageList,
  Upload,
  BatchUpload,
  Download,
  Delete,
  GetSetupPageList,
  GetDetail,
  Analysis,
  Save,
  SetupDelete,
  ResultSave,
  GetAnalysisResultPageList,
  ResultDelete,
  Rename,
  ResultGetDetail,
}
