from typing import List
import model, entity
from config import db


def createNotice(content: str, userId: int):
    try:
        # query user
        member = model.db.session.query(model.Member).filter(model.Member.userId == userId, model.Member.enableFlag == True).first()
        if not member:
            return
        userName = member.userName
        notice = model.Notice(userId, userName, content)
        # save database
        db.session.add(notice)
        db.session.commit()
    except Exception as e:
        print("fail to create notice: " + str(e))
        return
    

def viewDetail(id: int) -> entity.Notice:
    notice = model.db.session.query(model.Notice).filter(model.Notice.id == id, model.Notice.enableFlag == True).first()
    if not notice:
        raise Exception("notice not found")
    notice.readFlag = True
    db.session.commit()
    return entity.Notice(notice)


def getNoticePageList(body, loginUser: entity.LoginUser) -> entity.NoticePageList:
    pageIndex = body.get("pageIndex")
    if not pageIndex:
        raise Exception("page index is none")
    pageSize = body.get("pageSize")
    if not pageSize:
        raise Exception("page size is none")
    paginate = db.session.query(model.Notice).filter(model.Notice.userId == loginUser.userId).paginate(page=pageIndex, per_page=pageSize)
    content = []
    for item in paginate.items:
        obj = entity.Notice(item)
        content.append(obj)
    totalCount = paginate.total
    pageList = entity.NoticePageList(content, pageIndex, pageSize, totalCount)
    return pageList