from datetime import datetime
from config import db


# member
class Member(db.Model):
    __tablename__ = "base_member_info"
    userId = db.Column(db.Integer, primary_key=True)
    userName = db.Column(db.String(50), unique=True)
    password = db.Column(db.String(100))
    occupiedSpace = db.Column(db.Float)
    otherInfo = db.Column(db.String(500))
    roleId = db.Column(db.Integer)
    roleName = db.Column(db.String(50))
    enableFlag = db.Column(db.Boolean)
    def __init__(self, userName, password, occupiedSpace, otherInfo, roleId, roleName):
        self.userName = userName
        self.password = password
        self.occupiedSpace = occupiedSpace
        self.otherInfo = otherInfo
        self.roleId = roleId
        self.roleName = roleName
        self.enableFlag = True


# application
class ApplicationForm(db.Model):
    __tablename__ = "flow_apply_form"
    applyFormId = db.Column(db.String(50), primary_key=True)
    userId = db.Column(db.Integer)
    userName = db.Column(db.String(50))
    reason = db.Column(db.String(100))
    statusId = db.Column(db.Integer)
    statusName = db.Column(db.String(50))
    processUserId = db.Column(db.Integer)
    processUserName = db.Column(db.String(50))
    processDateTime = db.Column(db.DateTime)
    action = db.Column(db.String(20))
    createDateTime = db.Column(db.DateTime)
    enableFlag = db.Column(db.Boolean)


# notice
class Notice(db.Model):
    __tablename__ = "log_notice"
    id = db.Column(db.Integer, autoincrement=True, primary_key=True)
    userId = db.Column(db.Integer)
    userName = db.Column(db.String(50))
    content = db.Column(db.String(1000))
    readFlag = db.Column(db.Boolean)
    enableFlag = db.Column(db.Boolean)
    def __init__(self, userId, userName, content):
        self.userId = userId
        self.userName = userName
        self.content = content
        self.readFlag = False
        self.enableFlag = True


# analysis setup
class AnalysisSetup(db.Model):
    __tablename__ = "analysis_setup"
    setupId = db.Column(db.String(50), primary_key=True)
    setupName = db.Column(db.String(50))
    measures = db.Column(db.String(100))
    selectAll = db.Column(db.Boolean)
    fileIds = db.Column(db.String(255))
    createUserId = db.Column(db.Integer)
    createUserName = db.Column(db.String(100))
    createDateTime = db.Column(db.DateTime)
    enableFlag = db.Column(db.Boolean)
    def __init__(self, setupId, setupName, measures, createUserId, createUserName):
        self.setupId = setupId
        self.setupName = setupName
        self.measures = measures
        self.createUserId = createUserId
        self.createUserName = createUserName
        self.createDateTime = datetime.now()
        self.enableFlag = True


# analysis files
class AnalysisFile(db.Model):
    __tablename__ = "analysis_file"
    id = db.Column(db.Integer, primary_key=True, autoincrement=True)
    fileName = db.Column(db.String(100))
    filePath = db.Column(db.String(100))
    fileUrl = db.Column(db.Text)
    fileSize = db.Column(db.Float)
    createUserId = db.Column(db.Integer)
    createUserName = db.Column(db.String(100))
    enableFlag = db.Column(db.Boolean)
    def __init__(self, fileName, filePath, fileUrl, fileSize, createUserId, createUserName):
        self.fileName = fileName
        self.filePath = filePath
        self.fileUrl = fileUrl
        self.fileSize = fileSize
        self.enableFlag = True
        self.createUserId = createUserId
        self.createUserName = createUserName


# analysis result
class AnalysisResult(db.Model):
    __tablename__ = "analysis_result"
    resultId = db.Column(db.String(50), primary_key=True)
    resultName = db.Column(db.String(50))
    resultContent = db.Column(db.Text)
    createUserId = db.Column(db.Integer)
    createUserName = db.Column(db.String(100))
    createDateTime = db.Column(db.DateTime)
    enableFlag = db.Column(db.Boolean)
