import model, entity, constants, common, os, requests, urllib.request
from werkzeug.utils import secure_filename
from werkzeug.datastructures import FileStorage
from config import app, db


def uploadSetupFileFromLocal(f: FileStorage):
    fileName = f.filename
    # change file name to a unique name to avoid being covered
    fields = fileName.split(".")
    fileType = fields[len(fields) - 1]
    f.filename = common.generateUUID() + "." + fileType
    # file path in server
    filePath = os.path.join(constants.fileDir, f.filename)
    # KB
    fileSize = round(len(f.read()) / 1024, 2)
    # relative path to save file
    dir = os.path.join(app.instance_path, constants.fileDir)
    # make dir if not exist
    os.makedirs(dir, exist_ok=True)
    # save file locally
    f.save(os.path.join(dir, secure_filename(f.filename)))
    item = model.AnalysisFile(fileName, filePath, fileSize)
    db.session.add(item)
    db.session.commit()
    setupFile = db.session.query(model.AnalysisFile).filter(model.AnalysisFile.filePath == filePath, model.AnalysisFile.enableFlag == True).first()
    if not setupFile:
        raise Exception("upload failed")
    return entity.FileEntity(setupFile)


def uploadSetupFileFromUrl(url: str, loginUser: entity.LoginUser):
    dir = os.path.join(app.instance_path, constants.fileDir)
    if not os.path.exists(dir):
        os.makedirs(dir)  # create folder if it does not exist

    fileName = url.split('/')[-1].replace(" ", "_")  # be careful with file names
    fields = fileName.split(".")
    fileType = fields[len(fields) - 1]
    uuid = common.generateUUID()
    filePath = os.path.join(constants.fileDir, uuid + "." + fileType)
    try:
        urllib.request.urlretrieve(url, os.path.join(app.instance_path, filePath))
    except Exception as e:
        print(str(e))
        raise Exception("upload failed")
    f = open(os.path.join(app.instance_path, filePath), "r")
    fileSize = round(len(f.read()) / 1024, 2)
    item = model.AnalysisFile(fileName, filePath, url, fileSize, loginUser.userId, loginUser.userName)
    db.session.add(item)
    db.session.commit()
    setupFile = db.session.query(model.AnalysisFile).filter(model.AnalysisFile.filePath == filePath, model.AnalysisFile.enableFlag == True).first()
    if not setupFile:
        raise Exception("upload failed")
    return entity.FileEntity(setupFile)


def batchUpload(f: FileStorage, loginUser: entity.LoginUser):
    dir = os.path.join(app.instance_path, constants.fileDir)
    if not os.path.exists(dir):
        os.makedirs(dir)  # create folder if it does not exist
    # read line by line
    fileUrlList = []
    for line in f:
        fileUrlList.append(line.strip().decode())
    # get response 
    count = 0
    for fileUrl in fileUrlList:
        count += 1
        if count == 1:
            continue
        try:
            r = requests.get(fileUrl, stream=True)
            if r.ok is not True:
                raise Exception("file url in line {} is not valid".format(count))
        except Exception as e:
            raise Exception("file url in line {} is not valid".format(count))
    # upload result set
    uploadResults = []
    for i in range(1, len(fileUrlList) - 1):
        try:
            fileUrl = fileUrlList[i]
            fileName = fileUrl.split('/')[-1].replace(" ", "_")
            fields = fileName.split(".")
            fileType = fields[len(fields) - 1]
            filePath = os.path.join(constants.fileDir, common.generateUUID() + "." + fileType)
            # save local
            urllib.request.urlretrieve(fileUrl, os.path.join(app.instance_path, filePath))
            f = open(os.path.join(app.instance_path, filePath), "r")
            fileSize = round(len(f.read()) / 1024, 2)
            item = model.AnalysisFile(fileName, filePath, fileUrl, fileSize, loginUser.userId, loginUser.userName)
            db.session.add(item)
            uploadResults.append(entity.UploadResult(fileUrl, True, "upload done"))
        except:
            uploadResults.append(entity.UploadResult(fileUrl, False, "upload failed"))
    db.session.commit()
    return uploadResults


def downloadFile(id: int) -> model.AnalysisFile:
    if not id:
        raise Exception("id is none")
    item = db.session.query(model.AnalysisFile).filter(model.AnalysisFile.id == id, model.AnalysisFile.enableFlag == True).first()
    if not item:
        raise Exception("file not found")
    return item


def getFilePageList(body, loginUser: entity.LoginUser) -> entity.FilePageList:
    pageIndex = body.get("pageIndex")
    if not pageIndex:
        raise Exception("page index is none")
    pageSize = body.get("pageSize")
    if not pageSize:
        raise Exception("page size is none")
    paginate = None
    if loginUser.roleId != 3:
        paginate = db.session.query(model.AnalysisFile).filter(model.AnalysisFile.createUserId == loginUser.userId, model.AnalysisFile.enableFlag == True).paginate(page=pageIndex, per_page=pageSize)
    else:
        paginate = db.session.query(model.AnalysisFile).filter(model.AnalysisFile.enableFlag == True).paginate(page=pageIndex, per_page=pageSize)
    content = []
    for item in paginate.items:
        obj = entity.FileEntity(item)
        content.append(obj)
    totalCount = paginate.total
    pageList = entity.FilePageList(content, pageIndex, pageSize, totalCount)
    return pageList


def deleteFile(id: int):
    item = db.session.query(model.AnalysisFile).filter(model.AnalysisFile.id == id, model.AnalysisFile.enableFlag == True).first()
    if not item:
        raise Exception("file not found")
    item.enableFlag = False
    db.session.commit()


def getAllFiles(loginUser: entity.LoginUser):
    content = []
    models = []
    if loginUser.roleId != 3:
        models = db.session.query(model.AnalysisFile).filter(model.AnalysisFile.createUserId == loginUser.userId, model.AnalysisFile.enableFlag == True)
    else:
        models = db.session.query(model.AnalysisFile).filter(model.AnalysisFile.enableFlag == True)
    for item in models:
        obj = entity.FileEntity(item)
        content.append(obj)
    return content