import re
from typing import List
from constants import dateFormat
import model, jsonpickle


class LoginUser:
    def __init__(self, userId, userName, occupiedSpace, otherInfo, roleId, roleName):
        self.userId = userId
        self.userName = userName
        self.occupiedSpace = occupiedSpace
        self.otherInfo = otherInfo
        self.roleId = roleId
        self.roleName = roleName
        self.menuList = getMenuListByRole(self.roleId)
        

# operation key
notice = "notice"
approve = "approve"
manage_user = "manage_user"
manage_dataset = "manage_dataset"
account_setting = "account_setting"
data_analysis_setup = "data_analysis_setup"
data_analysis_result = "data_analysis_result"


def getMenuListByRole(roleId): 
    menuList = []
    if roleId == 1: 
        menuList.append(notice)
        menuList.append(data_analysis_result)
        menuList.append(account_setting)
    if roleId == 2:
        menuList.append(notice)
        menuList.append(data_analysis_setup)
        menuList.append(data_analysis_result)
        menuList.append(account_setting)
        menuList.append(manage_dataset)
    if roleId == 3:
        menuList.append(notice)
        menuList.append(approve)
        menuList.append(manage_user)
        menuList.append(data_analysis_setup)
        menuList.append(data_analysis_result)
        menuList.append(account_setting)
        menuList.append(manage_dataset)
    return menuList


class ResultEntity:
    def __init__(self, success, data, errMsg):
        self.success = success
        self.data = data
        self.errMsg = errMsg
    def toJson(self):
        return jsonpickle.encode(self, make_refs=False)


class ApplicationForm:
    applyFormId: str
    userId: int
    userName: str
    reason: str
    statusId: int
    statusName: str
    processUserId: int
    processUserName: str
    processDateTime: str
    action: str
    createDateTime: str
    def __init__(self, item: model.ApplicationForm):
        self.applyFormId = item.applyFormId
        self.userId = item.userId
        self.userName = item.userName
        self.reason = item.reason
        self.statusId = item.statusId
        self.statusName = item.statusName
        self.createDateTime = item.createDateTime.strftime(dateFormat)
        if item.action:
            self.processUserId = item.processUserId
            self.processUserName = item.processUserName
            self.processDateTime = item.processDateTime.strftime(dateFormat)
            self.action = item.action


class ApplicationPageList:
    def __init__(self, content, pageIndex, pageSize, totalCount):
        self.content = content
        self.pageIndex = pageIndex
        self.pageSize = pageSize
        self.totalCount = totalCount
        

class MemberPageList:
    def __init__(self, content, pageIndex, pageSize, totalCount):
        self.content = content
        self.pageIndex = pageIndex
        self.pageSize = pageSize
        self.totalCount = totalCount


class Notice:
    userId: int
    userName: str
    conent : str
    readFlag: bool
    def __init__(self, item: model.Notice):
        self.userId = item.userId
        self.userName = item.userName
        self.content = item.content
        self.readFlag = item.readFlag


class NoticePageList:
    def __init__(self, content, pageIndex, pageSize, totalCount):
        self.content = content
        self.pageIndex = pageIndex
        self.pageSize = pageSize
        self.totalCount = totalCount
        

class FileEntity:
    def __init__(self, item: model.AnalysisFile):
        self.id = item.id
        self.fileName = item.fileName
        self.filePath = item.filePath
        self.fileUrl = item.fileUrl
        self.fileSize = item.fileSize


class FilePageList:
    def __init__(self, content, pageIndex, pageSize, totalCount):
        self.content = content
        self.pageIndex = pageIndex
        self.pageSize = pageSize
        self.totalCount = totalCount


class MeasureEntity:
    measure: str
    value: str
    def __init__(self, measureName, measureValue):
        self.measure = measureName
        self.value = measureValue


class AnalysisResultByDataset:
    fileId: int
    fileName: str
    measureList: List
    def __init__(self, fileId, fileName, measureList):
        self.fileId = fileId
        self.fileName = fileName
        self.measureList = measureList
    

class DatasetEntity:
    fileId: int
    fileName: str
    value: str
    def __init__(self, fileId, fileName, value):
        self.fileId = fileId
        self.fileName = fileName
        self.value = value
        
        
class AnalysisResultByMeasure:
    measure: str
    datasetList: List
    def __init__(self, measure, datasetList):
        self.measure = measure
        self.datasetList = datasetList
    
    
class AnalysisSetupDetail:
    setupId: str
    setupName: str
    selectAll: bool
    fileList: List
    measureList: List
    createUserId: int
    createUserName: str
    createDateTime: str
    def __init__(self, item: model.AnalysisSetup):
        self.setupId = item.setupId
        self.setupName = item.setupName
        self.selectAll = item.selectAll
        self.createUserId = item.createUserId
        self.createUserName = item.createUserName
        self.createDateTime = item.createDateTime.strftime(dateFormat)


class AnalysisSetupPageList:
    def __init__(self, content, pageIndex, pageSize, totalCount):
        self.content = content
        self.pageIndex = pageIndex
        self.pageSize = pageSize
        self.totalCount = totalCount


class AnalysisResult:
    resultId: str
    resultName: str
    fileList: List
    resultByDateset: List
    resultByMeasure: List
    createUserId: int
    createUserName: str
    createDateTime: str
    def __init__(self, item: model.AnalysisResult):
        if item is None:
            return
        else:
            self.resultId = item.resultId
            self.resultName = item.resultName
            self.createUserId = item.createUserId
            self.createUserName = item.createUserName
            item.createDateTime
            self.createDateTime = item.createDateTime.strftime(dateFormat)
        
        
class AnalysisResultPageList:
    def __init__(self, content, pageIndex, pageSize, totalCount):
        self.content = content
        self.pageIndex = pageIndex
        self.pageSize = pageSize
        self.totalCount = totalCount
    

class UploadResult:
    def __init__(self, url, flag, result):
        self.url = url
        self.flag = flag
        self.result = result
