import account, datetime, entity, jsonpickle, notice, file, os, analysis
import pyexcel as pe
from config import app
from flask import Response, request, send_file, make_response
from constants import cookieKey, fernet
from io import StringIO

# for test
@app.route('/api/hello', methods=['GET'])
def hello():
    return "hello OK"


# login by username and password
@app.route('/api/account/login', methods=['POST'])
def login():
    userName = request.json["userName"]
    password = request.json["password"]
    response = None
    try:
        loginUser = account.login(userName, password)
        rs = entity.ResultEntity(True, "success", None)
        cookieStr = jsonpickle.dumps(loginUser)
        encryptStr = fernet.encrypt(cookieStr.encode())
        expires = datetime.datetime.utcnow() + datetime.timedelta(hours=24)
        response = Response(jsonpickle.dumps(rs), mimetype='application/json')
        response.set_cookie(cookieKey, str(encryptStr, encoding='utf-8'), expires=expires)
        return response
    except Exception as e:
        rs = entity.ResultEntity(False, None, str(e))
        response = Response(jsonpickle.dumps(rs), mimetype='application/json')
        return response


# logout
@app.route('/api/account/logout', methods=['GET'])
def logout():
    rs = entity.ResultEntity(True, 'success', None)
    response = Response(jsonpickle.dumps(rs), mimetype='application/json')
    response.set_cookie(cookieKey, '', expires=0)
    return response


# # check if login before request
@app.before_request
def before_request():
    url = str(request.url)
    if '/api/account/login' not in url and '/api/hello' not in url:
        cookieStr = request.cookies.get(cookieKey)
        if not cookieStr:
            rs = entity.ResultEntity(False, None, "please login")
            return Response(jsonpickle.dumps(rs), mimetype='application/json')


# get login user from cookie
@app.route('/api/account/getLoginUser', methods=['GET'])
def getLoginUser():
    rs = None
    try:
        loginUser = account.getLoginUser()
    except Exception as e:
        rs = entity.ResultEntity(False, None, str(e))
    else:
        rs = entity.ResultEntity(True, loginUser, None)

    return Response(jsonpickle.dumps(rs), mimetype='application/json')


# create a member
@app.route('/api/account/create', methods=['POST'])
def createMember():
    body = request.get_json(force=True)
    rs = None
    try:
        account.createMember(body)
    except Exception as e:
        rs = entity.ResultEntity(False, None, str(e))
    else:
        rs = entity.ResultEntity(True, "success", None)

    return Response(jsonpickle.dumps(rs), mimetype='application/json')


# update a member
@app.route('/api/account/update', methods=['POST'])
def updateMember():
    body = request.get_json(force=True)
    rs = None
    try:
        account.updateMember(body)
    except Exception as e:
        rs = entity.ResultEntity(False, None, str(e))
    else:
        rs = entity.ResultEntity(True, "success", None)

    return Response(jsonpickle.dumps(rs), mimetype='application/json')


@app.route('/api/account/getMemberPageList', methods=['POST'])
def getMemberPageList():
    body = request.get_json(force=True)
    pageList = account.getMemberPageList(body)
    rs = entity.ResultEntity(True, pageList, None)
    return Response(jsonpickle.dumps(rs), mimetype='application/json')


# delete a member
@app.route('/api/account/delete', methods=['POST'])
def deleteMember():
    body = request.get_json(force=True)
    rs = None
    try:
        account.deleteMember(body)
    except Exception as e:
        rs = entity.ResultEntity(False, None, str(e))
    else:
        rs = entity.ResultEntity(True, "success", None)
    
    return Response(jsonpickle.dumps(rs), mimetype='application/json')


# submit application
@app.route('/api/account/apply', methods=['POST'])
def apply():
    body = request.get_json(force=True)
    loginUser = account.getLoginUser()
    rs = None
    try:
        account.apply(body, loginUser=loginUser)
    except Exception as e:
        rs = entity.ResultEntity(False, None, str(e))
    else: 
        rs = entity.ResultEntity(True, "success", None)
        
    return Response(jsonpickle.dumps(rs), mimetype='application/json')


# approve the application
@app.route('/api/account/approve', methods=['POST'])
def approve():
    body = request.get_json(force=True)
    loginUser = account.getLoginUser()
    rs = None
    try:
        account.approve(body, loginUser=loginUser)
    except Exception as e:
        rs = entity.ResultEntity(False, None, str(e))
    else: 
        rs = entity.ResultEntity(True, "success", None)
        
    return Response(jsonpickle.dumps(rs), mimetype='application/json')


# get application by page
@app.route('/api/account/getApplyPageList', methods=['POST'])
def getApplyPageList():
    body = request.get_json(force=True)
    pageList = account.getApplyPageList(body)
    rs = entity.ResultEntity(True, pageList, None)
    return Response(jsonpickle.dumps(rs), mimetype='application/json')


# get notice by page
@app.route('/api/notice/getNoticePageList', methods=['POST'])
def getNoticePageList():
    body = request.get_json(force=True)
    loginUser = account.getLoginUser()
    pageList = notice.getNoticePageList(body, loginUser)
    rs = entity.ResultEntity(True, pageList, None)
    return Response(jsonpickle.dumps(rs), mimetype='application/json')  


# view notice detail
@app.route('/api/notice/view', methods=['GET'])
def viewNoticeDetail():
    id = request.args.get("id")
    rs = None
    if not id:
        rs = entity.ResultEntity(False, None, "please select one notice")
    else:
        obj = notice.viewDetail(id)
        rs = entity.ResultEntity(True, obj, None)
    return Response(jsonpickle.dumps(rs), mimetype='application/json')  


# analysis setup file upload
@app.route('/api/file/upload', methods=['POST'])
def upload():
    url = request.form["url"]
    loginUser = account.getLoginUser()
    rs = None
    try:
        obj = file.uploadSetupFileFromUrl(url, loginUser)
        rs = entity.ResultEntity(True, obj, None)
    except Exception as e:
        print("fail to upload file: " + str(e))
        rs = entity.ResultEntity(False, None, str(e))
    return Response(jsonpickle.dumps(rs), mimetype='application/json')  
    

@app.route('/api/file/batchUpload', methods=['POST'])
def batchUpload():
    f = request.files["file"]
    loginUser = account.getLoginUser()
    rs = None
    try:
        uploadResults = file.batchUpload(f, loginUser)
        rs = entity.ResultEntity(True, uploadResults, None)
    except Exception as e:
        rs = entity.ResultEntity(False, None, str(e))
    return Response(jsonpickle.dumps(rs), mimetype='application/json')  


# analysis setup file download
@app.route('/api/file/download', methods=['GET'])
def download():
    id = request.args.get("id")
    rs = None
    try:
        obj = file.downloadFile(id)
        filePath = os.path.join(app.instance_path, obj.filePath)
        return send_file(filePath, as_attachment=True, download_name=obj.fileName)
    except Exception as e:
        rs = entity.ResultEntity(False, None, "download failed: " + str(e))
        return Response(jsonpickle.dumps(rs), mimetype='application/json')


# get file page list by user
@app.route('/api/file/getFilePageList', methods=['POST'])
def getFilePageList():
    body = request.get_json(force=True)
    loginUser = account.getLoginUser()
    pageList = file.getFilePageList(body, loginUser)
    rs = entity.ResultEntity(True, pageList, None)
    return Response(jsonpickle.dumps(rs), mimetype='application/json')  


# get all files by user
@app.route('/api/file/getAllFiles', methods=['POST'])
def getAllFiles():
    loginUser = account.getLoginUser()
    pageList = file.getAllFiles(loginUser)
    rs = entity.ResultEntity(True, pageList, None)
    return Response(jsonpickle.dumps(rs), mimetype='application/json')  


# delete the uploaded file
@app.route('/api/file/delete', methods=['GET'])
def deleteFile():
    fileId = request.args.get("id")
    rs = None
    try:
        file.deleteFile(fileId)
        rs = entity.ResultEntity(True, "success", None)
    except Exception as e:
        rs = entity.ResultEntity(False, None, str(e))
    return Response(jsonpickle.dumps(rs), mimetype='application/json')  


# save setup
@app.route('/api/setup/save', methods=['POST'])
def saveAnalysisSetup():
    body = request.get_json(force=True)
    loginUser = account.getLoginUser()
    rs = None
    try:
        analysis.saveAnalysisSetup(body, loginUser)
        rs = entity.ResultEntity(True, "success", None)
    except Exception as e:
        rs = entity.ResultEntity(False, None, str(e))
    return Response(jsonpickle.dumps(rs), mimetype='application/json')


# get analysis setup detail
@app.route('/api/setup/getDetail', methods=['GET'])
def getAnalysisSetupDetail():
    setupId = request.args.get("setupId")
    loginUser = account.getLoginUser()
    try:
        detail = analysis.getAnalysisSetupDetail(loginUser, setupId)
        rs = entity.ResultEntity(True, detail, None)
    except Exception as e:
        rs = entity.ResultEntity(False, None, str(e))
    return Response(jsonpickle.dumps(rs), mimetype='application/json')


# delete setup
@app.route('/api/setup/delete', methods=['GET'])
def deleteAnalysisSetup():
    id = request.args.get("id")
    loginUser = account.getLoginUser()
    try:
        analysis.deleteAnalysisSetup(loginUser, id)
        rs = entity.ResultEntity(True, "success", None)
    except Exception as e:
        rs = entity.ResultEntity(False, None, str(e))
    return Response(jsonpickle.dumps(rs), mimetype='application/json')


# get setup by page
@app.route('/api/setup/getSetupPageList', methods=['POST'])
def getAnalysisSetupPageList():
    body = request.get_json(force=True)
    loginUser = account.getLoginUser()
    rs = None
    try:
        pageList = analysis.getAnalysisSetupPageList(body, loginUser)
        rs = entity.ResultEntity(True, pageList, None)
    except Exception as e:
        rs = entity.ResultEntity(False, None, str(e))
    return Response(jsonpickle.dumps(rs), mimetype='application/json')


# analysis
@app.route('/api/setup/analysis', methods=['POST'])
def doAnalysis():
    body = request.get_json(force=True)
    loginUser = account.getLoginUser()
    rs = None
    try:
        result = analysis.doAnalysis(body, loginUser)
        rs = entity.ResultEntity(True, result, None)
    except Exception as e:
        rs = entity.ResultEntity(False, None, str(e))
    return Response(jsonpickle.dumps(rs), mimetype='application/json')


# save the analysis setup detail
@app.route('/api/result/save', methods=['POST'])
def saveAnalysisResult():
    body = request.get_json(force=True)
    loginUser = account.getLoginUser()
    rs = None
    try:
        analysis.saveAnalysisResult(body, loginUser)
        rs = entity.ResultEntity(True, "success", None)
    except Exception as e:
        rs = entity.ResultEntity(False, None, str(e))
    return Response(jsonpickle.dumps(rs), mimetype='application/json')


@app.route('/api/result/rename', methods=['POST'])
def renameAnalysisResult():
    body = request.get_json(force=True)
    loginUser = account.getLoginUser()
    rs = None
    try:
        analysis.renameAnalysisResult(loginUser, body)
        rs = entity.ResultEntity(True, "success", None)
    except Exception as e:
        rs = entity.ResultEntity(False, None, str(e))
    return Response(jsonpickle.dumps(rs), mimetype='application/json') 


# get a saved analysis result
@app.route('/api/result/getDetail', methods=['GET'])
def getAnalysisResultDetail():
    resultId = request.args.get("resultId")
    rs = None
    try:
        result, _ = analysis.getAnalysisResultDetail(resultId)
        rs = entity.ResultEntity(True, result, None)
    except Exception as e:
        rs = entity.ResultEntity(False, None, str(e))
    return Response(jsonpickle.dumps(rs), mimetype='application/json')


# get saved result by page
@app.route('/api/result/getAnalysisResultPageList', methods=['POST'])
def getAnalysisResultPageList():
    body = request.get_json(force=True)
    loginUser = account.getLoginUser()
    rs = None
    try:
        pageList = analysis.getAnalysisResultPageList(body, loginUser)
        rs = entity.ResultEntity(True, pageList, None)
    except Exception as e:
        rs = entity.ResultEntity(False, None, str(e))
    return Response(jsonpickle.dumps(rs), mimetype='application/json')


# delete a saved analysis result
@app.route('/api/result/delete', methods=['GET'])
def deleteAnalysisResult():
    resultId = request.args.get("resultId")
    rs = None
    try:
        analysis.deleteAnalysisResult(resultId)
        rs = entity.ResultEntity(True, "success", None)
    except Exception as e:
        rs = entity.ResultEntity(False, None, "delete failed" + str(e))
    return Response(jsonpickle.dumps(rs), mimetype='application/json')


@app.route('/api/result/export', methods=['GET'])
def exportResult():
    resultId = request.args.get("resultId")
    result, resultName = analysis.getAnalysisResultDetail(resultId)
    data = []
    # add header
    resultByMeasure = result.get("resultByMeasure")
    headers = []
    headers.append("File Url")
    for item in resultByMeasure:
        headers.append(item.get("measure"))
    data.append(headers)
    # add row
    fileList = result.get("fileList")
    i = 0
    resultByDataset = result.get("resultByDateset")
    for item in resultByDataset:
        row = []
        row.append(fileList[i].get("fileUrl"))
        i += 1
        for measure in item.get("measureList"):
            row.append(measure.get("value"))
        data.append(row)
    io = StringIO()
    sheet = pe.Sheet(data)
    sheet.save_to_memory("csv", io)
    output = make_response(io.getvalue())
    output.headers["Content-Disposition"] = "attachment; filename=" + resultName + ".csv"
    output.headers["Content-type"] = "text/csv"
    return output


@app.route('/api/setup/export', methods=['GET'])
def exportSetup():
    loginUser = account.getLoginUser()
    setupId = request.args.get("setupId")
    setupDetail = analysis.getAnalysisSetupDetail(loginUser, setupId)
    data = []
    # add header
    headers = []
    headers.append("File Url")
    for item in setupDetail.measureList:
        if item == "Error":
            continue
        headers.append(item)
    data.append(headers)
    # add row
    fileList = setupDetail.fileList
    for item in fileList:
        row = []
        row.append(item.fileUrl)
        data.append(row)
    io = StringIO()
    sheet = pe.Sheet(data)
    sheet.save_to_memory("csv", io)
    output = make_response(io.getvalue())
    output.headers["Content-Disposition"] = "attachment; filename=" + setupDetail.setupName + ".csv"
    output.headers["Content-type"] = "text/csv"
    return output


# Run Server
if __name__ == '__main__':
    # init the database on thr first run, then you can comment this line of code
    # db.create_all()
    account.initAdminAccount()
    app.run(host='0.0.0.0', port=8081, debug=False)
