from asyncio import constants
from flask import request
from datetime import datetime
from config import db
from constants import cookieKey, fernet
import entity, model, jsonpickle, common, constants, notice, analysis


def initAdminAccount():
    member = model.db.session.query(model.Member).filter(model.Member.userId == 1, model.Member.enableFlag == True).first()
    if not member:
        adminMember = model.Member("admin", "admin", 1000, "init admin account", 3, "Administrator")
        # save database
        db.session.add(adminMember)
        db.session.commit()


def login(userName, password):
    if userName is None or len(userName) == 0:
        raise Exception("username is null")
    if password is None or len(password) == 0:
        raise Exception("password is null")
    member = model.db.session.query(model.Member).filter(model.Member.userName == userName, model.Member.enableFlag == True).first()
    if member is None:
        raise Exception("account is not found")
    if member.password != password:
        raise Exception("password is wrong")
    loginUser = entity.LoginUser(member.userId, member.userName, member.occupiedSpace, member.otherInfo, member.roleId, member.roleName)
    return loginUser


def getLoginUser() -> entity.LoginUser:
    cookieStr = request.cookies.get(cookieKey)
    if not cookieStr:
        raise Exception("please login")
    decMessage = fernet.decrypt(bytes(cookieStr, encoding='utf-8')).decode()
    decStr = jsonpickle.decode(decMessage)
    member = model.db.session.query(model.Member).filter(model.Member.userId == decStr.userId, model.Member.enableFlag == True).first()
    loginUser = entity.LoginUser(member.userId, member.userName, member.occupiedSpace, member.otherInfo, member.roleId, member.roleName)
    return loginUser


def createMember(body):
    userName = body.get("userName")
    if not userName:
        raise Exception("username is empty")
    # chech if there is repeat username
    repeatMember = model.db.session.query(model.Member).filter(model.Member.userName == userName, model.Member.enableFlag == True).first()
    if repeatMember is not None:
        raise Exception("username already exists")
    
    password = body.get("password")
    if not password:
        raise Exception("password is empty")
    occupiedSpace = body.get("occupiedSpace")
    if not occupiedSpace:
        raise Exception("please input the limit for overall size of datasets")
    otherInfo = body.get("otherInfo")
    roleId = body.get("roleId")
    if roleId == None:
        raise Exception("please select a role for this member")
    roleName = getRoleNameByRoleId(roleId)
    if not roleName:
        raise Exception("please select a correct role")
    member = model.Member(userName, password, occupiedSpace, otherInfo, roleId, roleName)
    # save database
    db.session.add(member)
    db.session.commit()
    # send notice
    member = model.db.session.query(model.Member).filter(model.Member.userName == userName, model.Member.enableFlag == True).first()
    loginUser = getLoginUser()
    content = "Ciao, your account has been created by {}".format(loginUser.userName)
    notice.createNotice(content, member.userId)
    analysis.createSampleResult(member)


def updateMember(body):
    userId = body.get("userId")
    if not userId:
        raise Exception("user id is none")
    # get the old info of member
    oldMember = model.db.session.query(model.Member).filter(model.Member.userId == userId, model.Member.enableFlag == True).first()
    if oldMember is None:
        raise Exception("the member not exists")
    # useraname
    userName = body.get("userName")
    if not userName:
        raise Exception("username is empty")
    oldMember.userName = userName
    # password
    password = body.get("password")
    if not password:
        raise Exception("password is empty")
    oldMember.password = password
    # occupiedSpace
    occupiedSpace = body.get("occupiedSpace")
    if not occupiedSpace:
        raise Exception("please input the limit for overall size of datasets")
    oldMember.occupiedSpace = occupiedSpace
    # otherInfo
    otherInfo = body.get("otherInfo")
    oldMember.otherInfo = otherInfo
    # role
    roleId = body.get("roleId")
    if roleId == None:
        raise Exception("please select a role for this member")
    roleName = getRoleNameByRoleId(roleId)
    if not roleName:
        raise Exception("please select a correct role")
    oldMember.roleId = roleId
    oldMember.roleName = roleName
    # save database
    db.session.commit()
    # send notice
    loginUser = getLoginUser()
    content = "Ciao, your account information has been updated by {}. Please pay attention to the changes.".format(loginUser.userName)
    notice.createNotice(content, userId)


def deleteMember(body):
    userId = body.get("userId")
    if not userId:
        raise Exception("user id is none")
    member = model.db.session.query(model.Member).filter(model.Member.userId == userId, model.Member.enableFlag == True).first()
    if not member:
        raise Exception("member is deleted")
    member.enableFlag = False
    db.session.commit()


def apply(body, loginUser: entity.LoginUser):
    # check if role of visitor
    roleId = loginUser.roleId
    if roleId != 1:
        raise Exception("your role is " + loginUser.roleName)
    # apply form
    applyForm = model.ApplicationForm()
    applyForm.applyFormId = common.generateUUID()
    applyForm.userId = loginUser.userId
    applyForm.userName = loginUser.userName
    applyForm.reason = body.get("reason")
    applyForm.statusId = constants.inProcess.statusId
    applyForm.statusName = constants.inProcess.statusName
    applyForm.createDateTime = datetime.now()
    applyForm.enableFlag = True
    # save database
    db.session.add(applyForm)
    db.session.commit()
    # send notice
    content = "{} has submit the application for access as user. Please approce.".format(loginUser.userName)
    admins = model.db.session.query(model.Member).filter(model.Member.roleId == 3, model.Member.enableFlag == True)
    for admin in admins:
        notice.createNotice(content, admin.userId)


def approve(body, loginUser: entity.LoginUser):
    # form id
    applyFormId = body.get("applyFormId")
    # action
    action = body.get("action")
    # get apply form
    applyForm = model.db.session.query(model.ApplicationForm).filter(model.ApplicationForm.applyFormId == applyFormId, model.ApplicationForm.enableFlag == True).first()
    if not applyForm:
        raise Exception("application not found")
    if applyForm.statusId != constants.inProcess.statusId:
        raise Exception("the application have been approved")
    if action == "agree":
        applyForm.statusId = constants.processEnd.statusId
        applyForm.statusName = constants.processEnd.statusName
    elif action == "reject":
        applyForm.statusId = constants.processEnd.statusId
        applyForm.statusName = constants.processEnd.statusName
    else:
        raise Exception("please choose to agree or reject the application")
    applyForm.processUserId = loginUser.userId
    applyForm.processUserName = loginUser.userName
    applyForm.processDateTime = datetime.now()
    applyForm.action = action
    # change the role of member
    if action == "agree":
        userId = applyForm.userId
        member = model.db.session.query(model.Member).filter(model.Member.userId == userId, model.Member.enableFlag == True).first()
        if not member:
            raise Exception("member not found")
        member.roleId = 2
        member.roleName = getRoleNameByRoleId(member.roleId)
    # save database
    try:
        db.session.commit()
    except:
        db.session.rollback()
        raise Exception("save failed")
    # send notice
    content = ""
    if action == "agree":
        content = "Your application for access as user has been agreed by {}.".format(loginUser.userName)
    elif action == "reject":
        content = "Sorry. Your application for access as user has been rejected by {}.".format(loginUser.userName)
    notice.createNotice(content, applyForm.userId)


def getApplyPageList(body):
    pageIndex = body.get("pageIndex")
    if not pageIndex:
        raise Exception("page index is none")
    pageSize = body.get("pageSize")
    if not pageSize:
        raise Exception("page size is none")
    paginate = db.session.query(model.ApplicationForm).filter().order_by(model.ApplicationForm.createDateTime.asc()).paginate(page=pageIndex, per_page=pageSize)
    content = []
    for item in paginate.items:
        obj = entity.ApplicationForm(item)
        content.append(obj)
    totalCount = paginate.total
    pageList = entity.ApplicationPageList(content, pageIndex, pageSize, totalCount)
    return pageList


def getMemberPageList(body):
    pageIndex = body.get("pageIndex")
    if not pageIndex:
        raise Exception("page index is none")
    pageSize = body.get("pageSize")
    if not pageSize:
        raise Exception("page size is none")
    paginate = db.session.query(model.Member).filter(model.Member.enableFlag == True).order_by(model.Member.userId.asc()).paginate(page=pageIndex, per_page=pageSize)
    content = []
    for item in paginate.items:
        obj = entity.LoginUser(item.userId, item.userName, item.occupiedSpace, item.otherInfo, item.roleId, item.roleName)
        obj.password = item.password
        content.append(obj)
    totalCount = paginate.total
    pageList = entity.MemberPageList(content, pageIndex, pageSize, totalCount)
    return pageList


def getRoleNameByRoleId(roleId):
    if roleId == 1:
        return "Visitor"
    if roleId == 2:
        return "User"
    if roleId == 3:
        return "Administrator"
    return "";
