import 'package:flutter/material.dart';
import 'package:scan/scan.dart';
import 'package:image_picker/image_picker.dart';

/// 扫描视图
class ScanPage extends StatelessWidget {
  ScanPage({Key key}) : super(key: key);

  IconData lightIcon = Icons.flash_on;
  final ScanController _controller = ScanController();

  // 展示图片结果弹窗
  void showAlertDialog(data,context) {
    showDialog<Null>(
        context: context,
        barrierDismissible: false,
        builder: (BuildContext context) {
          return new AlertDialog(
            title: new Text('Scan QR Code Result'),
            //可滑动
            content: new SingleChildScrollView(
              child: new Text(data),
            ),
            actions: <Widget>[
              new FlatButton(
                child: new Text('Sure'),
                onPressed: () {
                  Navigator.of(context).pop();
                },
              ),
              new FlatButton(
                child: new Text('Cancel'),
                onPressed: () {
                  Navigator.of(context).pop();
                },
              ),
            ],
          );
        });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text("Scan QR Code"),
      ),
      body: Stack(
          children: [
            ScanView(
              controller: _controller,
              scanLineColor: Color(0xFF4759DA),
              onCapture: (data) {
                _controller.pause();
                showAlertDialog(data,context);
              },
            ),
            Positioned(
              left: 50,
              bottom: 50,
              child: StatefulBuilder(
                builder: (BuildContext context, StateSetter setState) {
                  return MaterialButton(
                      child: Icon(lightIcon,size: 40,color: Color(0xFF4759DA),),
                      onPressed: (){
                        _controller.toggleTorchMode();
                        if (lightIcon == Icons.flash_on){
                          lightIcon = Icons.flash_off;
                        }else {
                          lightIcon = Icons.flash_on;
                        }
                        setState((){});
                      }
                  );
                },
              ),
            ),
            Positioned(
              right: 50,
              bottom: 50,
              child: MaterialButton(
                  child: Icon(Icons.image,size: 40,color: Color(0xFF4759DA),),
                  onPressed: () async {
                    final pickerImages = await ImagePicker().getImage(source: ImageSource.gallery);

                    if (pickerImages != null) {
                      _controller.pause();
                      String result = await Scan.parse(pickerImages.path);
                      if(result != null){
                        showAlertDialog(result,context);
                      }
                    }
                  }
              ),
            ),
          ]
      ),
    );
  }
}