`celldefine
`ifdef functional
   `timescale 1ns / 1ns
   `delay_mode_zero
`else
   `timescale 1ns / 1ns
   `delay_mode_path
`endif

module test (N1,N3,N6,N10,N11);

input N1,N3,N6;

output N10,N11;

integer now = 0;
integer fd;
reg clk;

	initial begin 
                clk = 1'b1;
                forever clk = #1 ~clk;
        end

        always @ (clk) begin
                now = now + 1;
        end

        initial begin
                fd = $fopen("../report/simulation_test.txt","w");
                while(1) begin
                        @(N1 or N3 or N6 or N10 or N11);
                        $fwrite(fd,now," ns:    N1=",N1," N3=",N3," N6=",N6," -> N10=",N10," N11=");
                        $fdisplay(fd,N11);
                end
                $fclose(fd);
        end


	NAND2_X1 #(.flag(1)) NAND1(
		.A1(N1),
		.A2(N3),
		.ZN(N10)
	);

	NAND2_X1 #(.flag(0)) NAND2(
		.A1(N3),
		.A2(N6),
		.ZN(N11)
	);

endmodule
