#!/bin/bash
# \
exec vsim -64 -do "$0"
echo "arguments"
#echo "$0"
set TB_TEST $::env(TB_TEST)
echo "TB_TEST"
echo $TB_TEST
set VSIM_FLAGS    "-GTEST=\"$TB_TEST\""

set TB            tb
set MEMLOAD       "PRELOAD"

source ./tcl_files/config/vsim.tcl

#do ./tcl_files/wave.do

#osservazione dei segnali tra due moduli del riscv instanziati nel tb, uno golden e l'altro faulty 

log -r *
add wave -divider CLK -color green -position insertpoint  \
sim:/tb/s_clk
add wave -divider INPUT  -color yellow -position insertpoint  \
sim:/tb/top_i/core_region_i/CORE/RISCV_CORE/ex_stage_i_alu_i/U1718/A1 \
sim:/tb/top_i/core_region_i/CORE/RISCV_CORE/ex_stage_i_alu_i/U2102/A1 \
sim:/tb/top_i/core_region_i/CORE/RISCV_CORE/ex_stage_i_alu_i/U2272/A1 \
sim:/tb/top_i/core_region_i/CORE/RISCV_CORE/ex_stage_i_alu_i/U1710/A \
sim:/tb/top_i/core_region_i/CORE/RISCV_CORE/ex_stage_i_alu_i/U1710/ZN \
sim:/tb/top_i/core_region_i/CORE/RISCV_CORE/ex_stage_i_alu_i/U2429/A2 \
sim:/tb/top_i/core_region_i/CORE/RISCV_CORE/ex_stage_i_alu_i/U1709/ZN \
sim:/tb/top_i/core_region_i/CORE/RISCV_CORE/ex_stage_i_alu_i/U1709/A1 
#add wave -color red -position insertpoint  \
#sim:/tb/top_i_f/core_region_i/CORE/RISCV_CORE/ex_stage_i_alu_i/U1718/A1
add wave -divider OUTPUT -color yellow -position insertpoint  \
sim:/tb/top_i/core_region_i/CORE/RISCV_CORE/instr_req_o
#add wave -color red -position insertpoint  \
#sim:/tb/top_i_f/core_region_i/CORE/RISCV_CORE/instr_req_o
add wave -color yellow -position insertpoint  \
sim:/tb/top_i/core_region_i/CORE/RISCV_CORE/data_req_o
#add wave -color red -position insertpoint  \
#sim:/tb/top_i_f/core_region_i/CORE/RISCV_CORE/data_req_o
add wave -color yellow -position insertpoint  \
sim:/tb/top_i/core_region_i/CORE/RISCV_CORE/data_we_o
#add wave -color red -position insertpoint  \
#sim:/tb/top_i_f/core_region_i/CORE/RISCV_CORE/data_we_o
add wave -color yellow -position insertpoint  \
sim:/tb/top_i/core_region_i/CORE/RISCV_CORE/instr_addr_o
#add wave -color red -position insertpoint  \
#sim:/tb/top_i_f/core_region_i/CORE/RISCV_CORE/instr_addr_o
add wave -color yellow -position insertpoint  \
sim:/tb/top_i/core_region_i/CORE/RISCV_CORE/data_addr_o
#add wave -color red -position insertpoint  \
#sim:/tb/top_i_f/core_region_i/CORE/RISCV_CORE/data_addr_o
add wave -color yellow -position insertpoint  \
sim:/tb/top_i/core_region_i/CORE/RISCV_CORE/data_wdata_o
#add wave -color red -position insertpoint  \
#sim:/tb/top_i_f/core_region_i/CORE/RISCV_CORE/data_wdata_o
add wave -color yellow -position insertpoint  \
sim:/tb/top_i/core_region_i/CORE/RISCV_CORE/data_be_o
#add wave -color red -position insertpoint  \
#sim:/tb/top_i_f/core_region_i/CORE/RISCV_CORE/data_be_o
#

#prova per capire se il flow e corretto
#force -freeze /tb/top_i/core_region_i/CORE/RISCV_CORE/ex_stage_i_alu_i/U1718/A1 1'h1 {80 ns}

#STF
set forbiddenTime 0
set delay 44000

when -fast {/top_i/core_region_i/CORE/RISCV_CORE/ex_stage_i_alu_i/int_div_div_i/U333/ZN'event and /top_i/core_region_i/CORE/RISCV_CORE/ex_stage_i_alu_i/int_div_div_i/U333/ZN = 1'h0} {
        uivar forbiddenTime
	uivar delay
        if {$now != $forbiddenTime} {
                force -freeze /tb/top_i/core_region_i/CORE/RISCV_CORE/ex_stage_i_alu_i/int_div_div_i/U333/ZN 1'h1 -cancel $delay
                set forbiddenTime [expr {$now + $delay}]
        }
}



vcd dumpports /tb/top_i/core_region_i/CORE/RISCV_CORE/* -file tmax/dumpports_rtl.riscv_core.vcde -unique
 
