#! /env/python

import sys
import re
import csv
import os
import math

#argv[0]: nome del programma stesso
#argv[1]: nome cartella sotto analisi inside reports

if len(sys.argv) != 2:
	print("[ERROR] : wrong number of arguments")
	sys.exit(-1)

tot = 0.0
n_observed = 0.0

fault_list = open("files/all_signals.txt","r")
with open(sys.argv[1] + "post_processing.csv","w") as destination:
    writer = csv.writer(destination)
    writer.writerow(["FAULT", "OBSERVED", "TYPE"])

for x in fault_list:
    tot = tot + 1
    words = x.split()
    ST = words[0]
    if ST == "F":
        fault = "STF"
    elif ST == "R":
        fault = "STR"
        
    signal = words[1].split('.')
    for x in signal:
        if x == "riscv_core":
            x = x.upper()
        fault = fault + "_" + x

    if os.stat(sys.argv[1] + fault + ".txt").st_size == 0:
        observed = "no"
	tipo = "none"
    else:
        observed = "yes"
	tipo = "data register error"
        n_observed = n_observed + 1
        
    with open(sys.argv[1] + "post_processing.csv","a") as destination:
        writer = csv.writer(destination)
        writer.writerow([fault, observed, tipo])

with open(sys.argv[1] + "post_processing.csv","a") as destination:
        writer = csv.writer(destination)
        writer.writerow(["TOT N FAULTS", "N FAULTS OBSERVED", "% OBSERVED"])
        writer.writerow([math.trunc(tot),math.trunc(n_observed),round((n_observed/tot)*100,2)])
        
fault_list.close()
        
        
        
        
        
        
