#! /env/python

import re

source = open ("../asic/techlib/NangateOpenCellLibrary_old.v","r")
destination = open("../asic/techlib/NangateOpenCellLibrary.v","w")

InModule = 0
readIO = 0
inputs = []
outputs = []
IO_list = []
sentence = ""
for line in source:
    if InModule == 0:
        destination.write(line)
        if(re.match("^module",line)):
            InModule = 1
    elif InModule == 1:
        
        if(re.match("^endmodule",line)):
            destination.write(line)
            InModule = 0
            inputs.clear()
            outputs.clear()
            readIO = 0
        elif (re.match("^\s*input",line)):
            destination.write(line)
            inputs.append(line.split()[1].split(";")[0]) #nome input 
            readIO = 1
        elif (re.match("^\s*output",line)):
            destination.write(line)
            outputs.append(line.split()[1].split(";")[0]) #nome output
        elif(line.startswith('\n') & readIO == 1):
            readIO = 0
            destination.write("\n")
            for x in inputs:
                destination.write("  wire " + x + "_sa0 = 1'b0;\n")
                destination.write("  wire " + x + "_sa1 = 1'b0;\n")
            for x in outputs:
                destination.write("  wire " + x + "_sa0 = 1'b0;\n")
                destination.write("  wire " + x + "_sa1 = 1'b0;\n")
                destination.write("  wire " + x + "_int;\n")
            destination.write("\n")
            for x in outputs:
                destination.write("  assign " + x + " = " + x + "_sa0 ? 1'b0 : " + x + "_sa1 ? 1'b1 : " + x + "_int;\n")
            destination.write("\n")
        elif (re.match("^\s*and|^\s*or|^\s*not|^\s*xor|^\s*buf|^\s*bufif|^\s*\\\\seq",line)):
            words1 = line.split("(") #0:logic_gate,1:IO);
            words2 = words1[1].split(")")[0] #0 IO
            IO = words2.split(",")
            IO_list.clear()
            sentence = words1[0] + "("
            for x in IO:
                IO_list.append(x.strip())
            for x in IO_list:
                for y in outputs:
                    if x == y:
                        IO_list[IO_list.index(x)] = x + "_int"
                for y in inputs:
                    if x == y:
                        IO_list[IO_list.index(x)] = x + "_sa0 ? 1'b0 : " + x + "_sa1 ? 1'b1 : " + x
            for x in IO_list:
                if IO_list.index(x) == len(IO_list)-1:
                    sentence = sentence + x + ");\n"
                else:
                    sentence = sentence + x + ",\n\t  "
            destination.write(sentence)
        else:
            destination.write(line)
            
destination.close()


       




       
