#!/bin/sh

./clean_all.sh
./compile_pulpino.sh
./compile_selftest.sh

#golden simulation

echo "Golden simulation analysis"
python ./py_files/comment.py ./vsim/tcl_files/run.tcl ./vsim/tcl_files/trashed.tcl y
./run_selftest_sim_nogui.sh
mv ./sw/build/apps/riscv_tests/polito/trace_core_00_0.log ./sw/build/apps/riscv_tests/polito/trace_core_00_0_gold.log
cp ./sw/build/apps/riscv_tests/polito/trace_core_00_0_gold.log ../reports/tracer_analysis/
python ./py_files/comment.py ./vsim/tcl_files/run.tcl ./vsim/tcl_files/trashed.tcl n

#Fault simulations
while IFS= read -r line; do 
	python ./py_files/modificaFile_modified_library.py ./vsim/tcl_files/run.tcl ./vsim/tcl_files/trashed.tcl $line; 
	rm ./vsim/tcl_files/trashed.tcl;
	var=$(cat files/signal.txt)
	if test -f "../reports/tracer_analysis/$var"; then
		echo "$var exist"
	else
		echo "$var analysis"
		./run_selftest_sim_nogui.sh; 
		diff ./sw/build/apps/riscv_tests/polito/trace_core_00_0_gold.log ./sw/build/apps/riscv_tests/polito/trace_core_00_0.log >> ../reports/tracer_analysis/${var}
	fi
done < ./files/all_signals.txt


