set IPS ../../.././ips
set RTL ../../.././rtl

# riscv
set SRC_RISCV " \
    $IPS/riscv/include/apu_core_package.sv \
    $IPS/riscv/include/riscv_defines.sv \
    $IPS/riscv/include/riscv_tracer_defines.sv \
    $IPS/riscv/riscv_alu.sv \
    $IPS/riscv/riscv_alu_basic.sv \
    $IPS/riscv/riscv_alu_div.sv \
    $IPS/riscv/riscv_compressed_decoder.sv \
    $IPS/riscv/riscv_controller.sv \
    $IPS/riscv/riscv_cs_registers.sv \
    $IPS/riscv/riscv_debug_unit.sv \
    $IPS/riscv/riscv_decoder.sv \
    $IPS/riscv/riscv_int_controller.sv \
    $IPS/riscv/riscv_ex_stage.sv \
    $IPS/riscv/riscv_hwloop_controller.sv \
    $IPS/riscv/riscv_hwloop_regs.sv \
    $IPS/riscv/riscv_id_stage.sv \
    $IPS/riscv/riscv_if_stage.sv \
    $IPS/riscv/riscv_load_store_unit.sv \
    $IPS/riscv/riscv_mult.sv \
    $IPS/riscv/riscv_prefetch_buffer.sv \
    $IPS/riscv/riscv_prefetch_L0_buffer.sv \
    $IPS/riscv/riscv_core.sv \
    $IPS/riscv/riscv_apu_disp.sv \
    $IPS/riscv/riscv_fetch_fifo.sv \
    $IPS/riscv/riscv_L0_buffer.sv \
"
set INC_RISCV " \
    $IPS/riscv/include \
    $IPS/riscv/../../rtl/includes \
"

# ---------- ANALYZE ------------------------------

# Set search path for include files
set search_path "${search_path} ${RTL} ${IPS} ${INC_RISCV} ${GATE_PATH}"

if { $TOPLEVEL == "riscv_core" } {

	analyze -f sverilog {  \
		components/cluster_clock_gating.sv \
		riscv/include/apu_core_package.sv \
		riscv/include/riscv_defines.sv \
		riscv/include/riscv_tracer_defines.sv \
		riscv/riscv_alu.sv \
		riscv/riscv_alu_basic.sv \
		riscv/riscv_alu_div.sv \
		riscv/riscv_compressed_decoder.sv \
		riscv/riscv_controller.sv \
		riscv/riscv_cs_registers.sv \
		riscv/riscv_debug_unit.sv \
		riscv/riscv_decoder.sv \
		riscv/riscv_int_controller.sv \
		riscv/riscv_ex_stage.sv \
		riscv/riscv_hwloop_controller.sv \
		riscv/riscv_hwloop_regs.sv \
		riscv/riscv_id_stage.sv \
		riscv/riscv_if_stage.sv \
		riscv/riscv_load_store_unit.sv \
		riscv/riscv_mult.sv \
		riscv/riscv_prefetch_buffer.sv \
		riscv/riscv_prefetch_L0_buffer.sv \
		riscv/riscv_core.sv \
		riscv/riscv_apu_disp.sv \
		riscv/riscv_fetch_fifo.sv \
		riscv/riscv_L0_buffer.sv \
		riscv/riscv_register_file_latch.sv \
	}

} else {
	echo "Non-existing top level."
	exit
}
