library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use std.textio.all;
use ieee.std_logic_textio.all;
use work.constants.all;

--------------------------------------------------------------------------------
--  Function:    
--  1.read data from file "data.txt" at every falling edge of the clock.
--  2.evey clock cycle, this unit reads 32bit from the "data.txt".

--  Assumption:    
--  1. the data source is saved data.txt,  already in format SM + NVZL  value
--  2. the file is organized in 16-bit per line

--  Notes:
--  1. Last tested on 11 Feb 2022. It has an individual testbench.                    
--------------------------------------------------------------------------------



entity sram_kernel is
    port(    
             kernel_clk : IN std_logic;
             kernel_reset : in std_logic;
             kernel_enable : in std_logic;
             kernel_index : out integer;
             kernel_data_valid : out std_logic;   
             kernel_data : OUT signed (SM_segment_bit-1 downto 0) 
     );
end sram_kernel;

architecture behavioral of sram_kernel is
    
    signal kernel_out : signed (SM_segment_bit-1 downto 0);
    signal kernel_index_signal : integer;
    signal kernel_enable_buffer : std_logic;
    signal file_valid : std_logic;

    type Memory_Array is array (0 to 300 ) of signed (SM_segment_bit - 1 downto 0);  --for test, since the big array slows down the simulation

    signal kernel_memory : Memory_Array;

    begin
    kernel_index  <= kernel_index_signal;

   
    kernel_enable_buffer  <= kernel_enable and file_valid;
   

    reading : process(index)

      file file_pointer : text;
      variable kernel_cell : std_logic_vector (SM_segment_bit - 1 downto 0);
      variable index : integer;
      variable data  : line;


    begin

    
        if (kernel_reset = '1') then
            file_open(file_pointer,"C:/Users/HAO/OneDrive/Desktop/Nullhop/kernel.txt",READ_MODE);
            kernel_out <= (others => '0');
            kernel_data_valid  <= '0';
            file_valid  <= '1';
            kernel_index_signal  <= -1;
            index := 0;

        elsif (kernel_enable_buffer = '1') then
               file_open(file_pointer,"C:/Users/HAO/OneDrive/Desktop/Nullhop/kernel.txt",READ_MODE);

               if(not(endfile(file_pointer))) then
                readline(file_pointer, data); 
                read(data, kernel_cell);


                kernel_memory(index)  <=  signed(kernel_cell);
                index := index + 1;
                kernel_data_valid  <= '1';
                kernel_index_signal  <= kernel_index_signal + 1;
                else 
                    file_close(file_pointer);
                    file_valid  <= '0';
                end if;
        end if;

    end process reading;

end behavioral;