LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
use work.func_external.all;


entity sig_altmult_accum is
	port 
	(
		kernel_value		: in signed(15 downto 0);
		pixel_value			: in signed (15 downto 0);
		mac_clk					: in std_logic;
		mac_reset				: in std_logic;
		mac_enable				: in std_logic;


		accum_out			: out signed (31 downto 0)
	);
	
end entity;

architecture rtl of sig_altmult_accum is

	-- Declare registers for intermediate values
	signal kernel_value_reg : signed (15 downto 0);
	signal pixel_value_reg : signed (15 downto 0);
	signal mac_reset : std_logic;
	signal mult_reg : signed (31 downto 0);
	signal adder_out : signed (31 downto 0);
	signal old_result : signed (31 downto 0);

begin

	mult_reg <= kernel_value_reg * pixel_value_reg;
	
	process (adder_out, mac_reset)
	begin
		if (mac_reset = '1') then
			-- Clear the accumulated data
			old_result <= (others => '0');
		else
			old_result <= adder_out;
		end if;
	end process;
	
	process (mac_clk)
	begin
		if (mac_enable = '1') then 
			if (rising_edge(mac_clk)) then
				kernel_value_reg <= kernel_value;
				pixel_value_reg <= pixel_value;
				mac_reset <= sload;
				
				-- Store accumulation result in a register
				adder_out <= old_result + mult_reg;
			end if;
		end if;
	end process;
	
	-- Output accumulation result
	accum_out <= adder_out;
	
end rtl;
