LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
use work.func_external.all;

--------------------------------------------------------------------------------
--  Function:    
--  1.read data from file "data.txt" at every falling edge of the clock.
--  2.evey clock cycle, this unit reads 32bit from the "data.txt".

--  Assumption:    
--  1. the data source is saved data.txt,  already in format SM + NVZL  value
--  2. the file is organized in 16-bit per line

--  Notes:
--  1. Last tested on 11 Feb 2022. It has an individual testbench.                    
--------------------------------------------------------------------------------



entity pre_buffer is
    port(    
             pre_buffer_clk     : IN std_logic;
             pre_buffer_reset   : in std_logic;
             pre_buffer_enable  : in std_logic;
             pre_buffer_address : in integer;
             ccm_result_1         : in integer;
             ccm_result_2         : in integer;
             relu_enable            : in integer;
             --pre_buffer_number : in integer;
             --pre_buffer_compute_done : in std_logic;
             pre_buffer_data_valid  : out std_logic;   
             pre_buffer_data        : OUT signed (SM_segment_bit-1 downto 0) 
     );
end pre_buffer;

architecture behavioral of pre_buffer is
    
    signal file_valid : std_logic;

    type pre_buffer_Array is array (0 to 127 ) of signed (SM_segment_bit - 1 downto 0);  --for test, since the big array slows down the simulation

    signal pre_buffer : pre_buffer_Array;
    begin


    process (pre_buffer_clk)
    begin
        if pre_buffer_reset = '1' then

        elsif rising_edge(pre_buffer_clk) then        
            if pre_buffer_enable = '1' then
                    -- Read pre_buffer
                    pre_buffer_data <= pre_buffer_pre_buffer(((pre_buffer_address)));
                    pre_buffer_data_valid  <= '1';
                    --pre_buffer_index  <= pre_buffer_index + 1;
                --else
                    --pre_buffer_data_valid  <= '0';
                --end if;
            else
                pre_buffer_data_valid  <= '0';
                end if;
            end if;      
    end process;


        -- Write process
        process (pre_buffer_clk)
        variable pre_write_address : integer range 0 to 300;   
      
        begin

            if (pre_buffer_reset = '0') then                     -- Clear pre_buffer
                pre_buffer  <=  (others  => (others =>'0'));

            elsif rising_edge(pre_buffer_clk) then

                if pre_buffer_clk = '1' then
                    pre_buffer <= (others => (others => '0'));
                    pre_write_address := 0;   

                elsif ((pre_buffer_enable = '1') ) then

                    if ((relu_enable = '1') ) then
                        -- Store dram_data to Current pre_buffer Address
                        if (ccm_result_1 > 0) then
                            pre_buffer(pre_write_address) <= ccm_result_1;
                            pre_write_address := pre_write_address + 1;
                        else
                            pre_buffer(pre_write_address) <= 0;
                            pre_write_address := pre_write_address + 1;
                        end if;

                        if (ccm_result_2 > 0) then
                            pre_buffer(pre_write_address) <= ccm_result_2;
                            pre_write_address := pre_write_address + 1;
                        else
                            pre_buffer(pre_write_address) <= 0;
                            pre_write_address := pre_write_address + 1;
                        end if;

                    else
                            pre_buffer(pre_write_address) <= ccm_result_1;
                            pre_write_address := pre_write_address + 1;
                            pre_buffer(pre_write_address) <= ccm_result_2;
                            pre_write_address := pre_write_address + 1;
                    end if;
                end if;
            end if; 
            
        end process;


        




        
    end Behavioral;

