LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;

entity pre_buffer is
	port (
		 pre_buffer_clk   			: in std_logic;
		 pre_buffer_reset 			: in std_logic;
		 pre_buffer_enable 			: in std_logic;
		 max_pooling_enable			: in std_logic;
		 relu_enable				: in std_logic;
		 din_shift					: in std_logic;
		 ccm_din_data_valid			: in std_logic;		--shift signal sent from mac_ccm
		 ccm_din1					: in integer;
		 ccm_din2					: in integer;
		 ccm_din3					: in integer;
		 ccm_din4					: in integer;
		 ccm_din5					: in integer;
		 ccm_din6					: in integer;
		 ccm_din7					: in integer;
		 ccm_din8					: in integer;
		 ccm_din9					: in integer;
		 ccm_din10					: in integer;
		 ccm_din11					: in integer;
		 ccm_din12					: in integer;
		 ccm_din13					: in integer;
		 ccm_din14					: in integer;
		 ccm_din15					: in integer;
		 ccm_din16					: in integer;
		 --output_valid 				: out std_logic;
		 output1 					: out integer;
		 output2 					: out integer
		 );
end pre_buffer;


architecture pre_buffer_arc of pre_buffer is
	
type Memory_Array is array (0 to 127 ) of integer;   --
signal pre_buffer_0 : Memory_Array;

signal column_index 		: integer;
signal row_index 			: integer;
signal column_index_std  	: std_logic_vector ( 7 downto 0);
signal output1_reg, output2_reg : integer;
signal din_data_valid 		: std_logic;
signal output_valid 		: std_logic;
begin

column_index_std  <= to_unsigned(column_index,8);


process ( pre_buffer_reset,pre_buffer_clk, din_data_valid)
begin

	if (pre_buffer_reset = '1') then
		output1_reg  <= 0;
		output2_reg  <= 0;
		din_data_valid  <= '0';

	elsif(pre_buffer_enable = '1') then

		if(din_data_valid = '1') then
			din1  <= ccm_din1;
			din2  <= ccm_din2;
			din_data_valid  <= '1';
		else
			din1  <= 0;
			din2  <= 0;
			din_data_valid  <= '0';
		end if;

	end if;

end process;


process (pre_buffer_reset,pre_buffer_clk) is 



begin
		if(pre_buffer_reset = '1') then
			column_index  <= 0;
			tmp  <= 0;
			output1  <= 0;
			output2  <= 0;

		elsif (pre_buffer_enable = '1') then 
			if ( din_data_valid = '1' ) then
				column_index  <= column_index + 1;
				output_valid   <= '1';

				if (max_pooling_enable  = '1') then 

					if ( column_index_std(0) = '0' ) then

						if din1 >= din2 then 
							tmp  <= din1;
						else
							tmp  <= din2;
						end if;

					elsif ( column_index_std(0) = '1' ) then

						if din1 >= din2 then
							
							if din1 >= tmp then
								if (relu_enable = '1') then
									if ( din1 >= 0) then
										output1  <= din1;
									else
										output1  <= 0;
									end if;
								else
									output1  <= din1;
								end if;

							else
								if (relu_enable = '1') then

									if (tmp >= 0) then
										output1  <= tmp;
									else
										output1  <= 0;
									end if;
								else
									output1  <= tmp;
								end if;

							end if;

						else

							if din2 >= tmp then
								if (relu_enable = '1') then
									if ( din2 >= 0 ) then
										output1  <= din2;
									else
										output1  <= 0;
									end if;
								else
									output1  <= din2;
								end if;

							else
								if (relu_enable = '1') then
									if ( tmp >= 0) then
										output1  <= tmp;
									else 
										output1  <= 0;
									end if;
								else
									output1  <= tmp;
								end if;

							end if;

						end if;
					end if;


				else  	------------------------------------------------------max pooling is off
					if (relu_enable = '1') then
						if ( din1 >= 0) then
							output1  <= din1;
						else
							output1  <= 0;
						end if;

						if ( din2 >= 0) then
							output2  <= din2;
						else
							output2  <= 0;
						end if;
					else
						output1  <= din1;
						output2  <= din2;
					end if;
			

				end if;

			else
				output_valid  <= '0';	
			end if;
		end if;


end process;
