LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
use work.func_external.all;



entity pixel_memory_bank is
	generic (data_width : data_width
			 pixel_memory_bank_number : pixel_memory_bank_number
			 SIZE_sram_address : SIZE_sram_address
			 SM_segment_bit : SM_segment_bit
			 );
	port (
		clock 				: in std_logic;
		reset 				: in std_logic;
		dram_data	 		: in STD_LOGIC_VECTOR (data_width-1 downto 0);
		read_array 			: in STD_LOGIC_VECTOR (pixel_memory_bank_number-1 downto 0);
		write_array			: in STD_LOGIC_VECTOR (pixel_memory_bank_number-1 downto 0);
		address             : in STD_LOGIC_VECTOR (SIZE_sram_address-1 downto 0);

		
		row_starting_address: out STD_LOGIC_VECTOR (SIZE_sram_address-1 downto 0);
		sm  				: out STD_LOGIC_VECTOR (SM_segment_bit-1 downto 0);
		pixel_value 		: out STD_LOGIC_VECTOR (data_width-1 downto 0)
	);
end pixel_memory_bank;




architecture behavioral of pixel_memory_bank is


--component bus2
--	port (
--		clock : in  std_logic;
--		reset : in  std_logic;
--		A 	  : in  std_logic_vector (bus_width-1 downto 0);
--		B 	  : out std_logic_vector (bus_width-1 downto 0)

--	);
--end component;

component SRAM


    generic (
            bus_width : integer
            SIZE_sram_address : integer
            data_width : integer
            );                                  
    Port ( 

        clock                : in  STD_LOGIC;
        reset                : in  STD_LOGIC;
        sram_input          : in  STD_LOGIC_VECTOR (bus_width - 1 downto 0);
        read_address         : in  STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
        write_en              : in  STD_LOGIC;
        read_en               : in  STD_LOGIC;
        enable               : in  STD_LOGIC;
        dataout              : out STD_LOGIC_VECTOR (data_width - 1 downto 0);
        row_starting_address : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0)

    );



end component;



signal 

begin

sram_bank:   for bank_index in 0 to pixel_memory_bank_number-1 generate                      --row 1 to row 3 are following one algorithm

	generic map ( 	bus_width : bus_width, 
					data_width : data_width, 
					SIZE_sram_address : SIZE_sram_address)
	 sram_connecting: SRAM port map (   
		 	
		 	clock   				=> clock
			reset   				=> reset
			sram_input 				=> dram_data
			read_address  			=> address     
			write_en        		=> write_array(bank_index)   
			read_en           		=> read_array(bank_index)
			enable              	=> enable
			dataout             	=> dataout
			row_starting_address  	=> row_starting_address                    
		 	
	end generate sram_bank;


end behavioral;