LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
use work.func_external.all;



entity pixel_memory_bank is
	port (
      bank_clk 				   : in std_logic;
		bank_reset 				   : in std_logic;
		bank_dram_data	 		   : in STD_LOGIC_VECTOR (bus_width-1 downto 0);
		read_array 			      : in STD_LOGIC_VECTOR (pixel_memory_bank_number-1 downto 0);
		write_array			      : in STD_LOGIC_VECTOR (pixel_memory_bank_number-1 downto 0);
		bank_read_address       : in STD_LOGIC_VECTOR (SIZE_sram_address+1 downto 0);
		bank_enable			      : in std_logic_vector (pixel_memory_bank_number-1 downto 0);
		bank_full			      : out std_logic_vector (pixel_memory_bank_number-1 downto 0);

		pixel_value 		      : out STD_LOGIC_VECTOR (SM_segment_bit-1 downto 0);
		bank_row_starting_address: out STD_LOGIC_VECTOR (SIZE_sram_address-1 downto 0)
	);
end pixel_memory_bank;




architecture behavioral of pixel_memory_bank is


component SRAM                         
     Port ( 

        clk                       : in  STD_LOGIC;
        reset                     : in  STD_LOGIC;
        dram_data                 : in  STD_LOGIC_VECTOR (bus_width - 1 downto 0);
        sram_read_address         : in  STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
        sram_write_en             : in  STD_LOGIC;
        sram_read_en              : in  STD_LOGIC;
        sram_enable               : in  STD_LOGIC;
        sram_full                 : out  std_logic;
        sram_data                 : out STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
        row_starting_address      : out STD_LOGIC_VECTOR (SIZE_sram_address -1  downto 0)
    );

end component;

begin

sram_bank:   for bank_index in 0 to pixel_memory_bank_number-1 generate                      --row 1 to row 3 are following one algorithm

	sram_connecting: SRAM port map (	 	
        clk                  => bank_clk,               
        reset                => bank_reset,               
        dram_data            => bank_dram_data,          
        sram_read_address    => bank_read_address(SIZE_sram_address-1 downto 0),     
        sram_write_en        => write_array(bank_index),        
        sram_read_en         => read_array(bank_index),         
        sram_enable          => bank_enable(bank_index),          
        sram_full            => bank_full(bank_index),           
        sram_data            => pixel_value,            
        row_starting_address => bank_row_starting_address(SIZE_sram_address-1 downto 0)
        );		 	
	end generate sram_bank;


end behavioral;