LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;

 -------------------------------------------------------------------------------

 -------------------------------------------------------------------------------
 
entity output_buffer is
                          
    Port ( 

        output_buffer_clk         : in  STD_LOGIC;
        output_buffer_enable      : in  STD_LOGIC;
        output_buffer_reset       : in  STD_LOGIC;
        data_valid                : in  std_logic;
        data1                     : in  integer;
        data2                     : in  integer;
        
        output_buffer_data0            : out STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
        output_buffer_data1            : out STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
        output_buffer_data2            : out STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
        output_buffer_data3            : out STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
        output_buffer_read_data_valid : out std_logic
    );
end output_buffer;
 
architecture Behavioral of output_buffer is

    --type Memory_Array is array (0 to (2 ** SIZE_output_buffer_address) - 1) of STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
    type Memory_Array is array (0 to 3844 ) of integer;  --for test, since the big array slows down the simulation

    signal buffer0 : Memory_Array;

begin

 
    -- Write process
    process (output_buffer_clk)
    variable output_buffer_write_address : integer range 0 to 300;   
  
    begin
        if rising_edge(output_buffer_clk) then
            if output_buffer_reset = '1' then
                -- Clear Memory on output_buffer_reset
                Memory <= (others => (others => '0'));
                output_buffer_full <= '0';
                output_buffer_write_address := 0;   --value needs to be changed if change the number of output_buffer banks
                                               -- if bank number = 4; we use 0 to 65535
                                               -- if bank number = 8; we use 0 to 65535*2
            elsif ((output_buffer_enable = '1') and (output_buffer_write_address < 300)) then
                if ((output_buffer_write_en = '1') ) then
                    if (dram_data_valid = '1') then
                    -- Store dram_data to Current Memory Address
                    Memory(output_buffer_write_address) <= dram_data(15 downto 0);
                    output_buffer_write_address := output_buffer_write_address + 1;
                    Memory(output_buffer_write_address) <= dram_data(31 downto 16);
                    output_buffer_write_address := output_buffer_write_address + 1;
                    end if;
                end if;
            end if;
        end if; 
        
        if (output_buffer_write_address = 300) then
            output_buffer_full <='1';      
        end if;
    end process;
end Behavioral;