LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
use work.func_external.all;


--------------------------------------------------------------------------------
-- 
--------------------------------------------------------------------------------


entity mac_control is
	port (
		pixel_value			: in integer;
		--pixel_valid 		: in integer;
		mac_control_clk					: in std_logic;
		mac_control_reset				: in std_logic;
		mac_control_enable				: in std_logic;
		mac_control_compute_done		: in std_logic;
		pixel_x 			            :in integer;
		pixel_y 			            :in integer;
		pixel_z 			            :in integer;
		stripe_status                   :in std_logic;

		control_x 			            :out integer;
		control_y 			            :out integer;
		control_z 			            :out integer;
		address_done					:out std_logic;
		control_pixel		            :out integer;
		--control_pixel_valid				:out integer;
		control_kernel_number 			:out integer;
		control_kernel_address_ready    :out integer;
		control_kernel_address			:out integer
	);
end mac_control;

architecture behavioral of mac_control is

	type type_state is (reset,mac_start,new_stripe,mac_prepare,done,one_state_buffer,six_state_down2,one_state_00,one_state_05,one_state_30,one_state_35,two_state_01,two_state_04,two_state_10,two_state_15,two_state_20,two_state_25,two_state_31,two_state_34,four_state_11,four_state_14,four_state_21,four_state_24,three_state_02,three_state_32,six_state_up2);
	signal current_state,next_state,tmp_state : type_state;
	signal x_reg, y_reg, z_reg,y_reg_reg : integer;
	signal pixel_reg : integer;
	signal two_index,three_index,four_index,six_index : integer;
	signal kernel_address : integer;
	signal kernel_address_ready : integer;
	signal layer_addition : integer;
	signal stripe : integer;
	signal index : integer;


begin

	control_kernel_address   	<= kernel_address;
	control_x  	                <= x_reg;
	control_y  	                <= y_reg;
	control_z  	                <= z_reg;
	control_pixel  	            <= pixel_reg;
	--control_pixel_valid         <= pixel_valid;
	control_kernel_address_ready  <= kernel_address_ready;

synchronous_pixel : process(mac_control_clk,mac_control_reset)
begin
	if (mac_control_reset = '1') then
		x_reg  		<= 0; 
		y_reg  		<= 0; 
		z_reg  		<= 0; 
		stripe  <= 1;

	elsif (rising_edge (mac_control_clk)) then
		if (stripe_status = '1') then
			stripe  <= stripe + 1;
		end if;

		x_reg  		<= pixel_x;
		y_reg  		<= pixel_y;
		y_reg_reg   <= y_reg;
		z_reg  		<= pixel_z;
		pixel_reg  	<= pixel_value;

	end if;
end process;

-----------------------------------------------------------------------------
--  next state
-----------------------------------------------------------------------------	

	next_state_proc: process(mac_control_clk,mac_control_reset)
	begin
			if (mac_control_reset = '1') then
				current_state  <= reset;
				index  <= 0;


			elsif (rising_edge(mac_control_clk)) then
				if (mac_control_enable = '1') then

					current_state  <= next_state;
						
							if( index  <= 16) then 
								index  <= index + 1;
							else 
								index  <= 0;
							end if;
				else 
					current_state  <= reset;
				end if;
			end if;
	end process next_state_proc;

--------------------------------------------------------------------------------
-- future state network
--------------------------------------------------------------------------------

	future_state_proc: process(current_state,index,x_reg,y_reg,z_reg)
	begin
		
		case current_state is

			when reset => 
				if (mac_control_enable = '1') then
					next_state  <= mac_start;
					address_done  <= '0';
				else
					next_state  <= reset;
					address_done  <= '0';
				end if;

			when mac_start  => 
				if (mac_control_enable = '1') then
					--if( mac_control_stop = '0') then 
					next_state  <= mac_prepare;
					address_done  <= '0';
					--else
					--next_state  <= mac_start;
					--address_done  <= '0';
					--end if;
				else
					next_state  <= reset;
					tmp_state   <= mac_start;
				end if;
			
			when mac_prepare => 
				if (mac_control_enable = '1') then
					address_done  <= '0';
					--if(pixel_valid = 2) then 
				
						if ( y_reg = 0 ) then

							if ( (x_reg = 0  and stripe = 1) or  (x_reg = 2  and stripe = 2) ) then
								next_state  <= one_state_00;
							elsif ( (x_reg = 3  and stripe = 1) or (x_reg = 5  and stripe = 2) ) then
								next_state  <= one_state_30;
							elsif (  (x_reg = 1  and stripe = 1) or (x_reg = 3  and stripe = 2) ) then
								next_state  <= two_state_10;
							elsif (  (x_reg = 2  and stripe = 1)  or (x_reg = 4  and stripe = 2)) then
								next_state   <= two_state_20;
							end if;


						elsif ( y_reg = 1) then


							if ( (x_reg = 0  and stripe = 1) or  (x_reg = 2  and stripe = 2) ) then
								next_state  <= two_state_01;
							elsif ( (x_reg = 3  and stripe = 1) or (x_reg = 5  and stripe = 2) ) then
								next_state  <= two_state_31;
							elsif (  (x_reg = 1  and stripe = 1) or (x_reg = 3  and stripe = 2) ) then
								next_state  <= four_state_11;
							elsif (  (x_reg = 2  and stripe = 1)  or (x_reg = 4  and stripe = 2)) then
								next_state   <= four_state_21;
							end if;

						elsif ( y_reg > 1 and y_reg < 4) then


							if ( (x_reg = 0  and stripe = 1) or  (x_reg = 2  and stripe = 2) ) then
								next_state  <= three_state_02;
							elsif ( (x_reg = 3  and stripe = 1) or (x_reg = 5  and stripe = 2) ) then
								next_state  <= three_state_32;
							elsif (  (x_reg = 1  and stripe = 1) or (x_reg = 3  and stripe = 2) ) then
								next_state  <= six_state_up2;
							elsif (  (x_reg = 2  and stripe = 1)  or (x_reg = 4  and stripe = 2)) then
								next_state   <= six_state_down2;
							end if;


						elsif ( y_reg = 4) then

							if ( (x_reg = 0  and stripe = 1) or  (x_reg = 2  and stripe = 2) ) then
								next_state  <= two_state_04;
							elsif ( (x_reg = 3  and stripe = 1) or (x_reg = 5  and stripe = 2) ) then
								next_state  <= two_state_34;
							elsif (  (x_reg = 1  and stripe = 1) or (x_reg = 3  and stripe = 2) ) then
								next_state  <= four_state_14;
							elsif (  (x_reg = 2  and stripe = 1)  or (x_reg = 4  and stripe = 2)) then
								next_state   <= four_state_24;
							end if;

						elsif ( y_reg = 5) then

							if ( (x_reg = 0  and stripe = 1) or  (x_reg = 2  and stripe = 2) ) then
								next_state  <= one_state_05;
							elsif ( (x_reg = 3  and stripe = 1) or (x_reg = 5  and stripe = 2) ) then
								next_state  <= one_state_35;
							elsif (  (x_reg = 1  and stripe = 1) or (x_reg = 3  and stripe = 2) ) then
								next_state  <= two_state_15;
							elsif (  (x_reg = 2  and stripe = 1)  or (x_reg = 4  and stripe = 2)) then
								next_state   <= two_state_25;
							end if;

						--end if;



					else
						next_state  <= mac_prepare;
					end if;
				else
					next_state  <= reset;
				end if;
--------------------------------------------------------------------------------
-- one pixel with one kernel weights, totally 4 cases
--------------------------------------------------------------------------------
			when one_state_buffer  => 
			if (mac_control_enable = '1' ) then 
				next_state  <= done;
				address_done  <= '1';
			end if;



			when one_state_00  =>
			if (mac_control_enable = '1' ) then 
				next_state  <= one_state_buffer;
				--address_done  <= '1';
			end if;

			when one_state_05  => 
			if (mac_control_enable = '1' ) then 
				next_state  <= one_state_buffer;
				--address_done  <= '1';
			end if;

			when one_state_30  => 
			if (mac_control_enable = '1' ) then 
				next_state  <= one_state_buffer;
				--address_done  <= '1';
			end if;

			when one_state_35  => 
			if (mac_control_enable = '1' ) then 
				next_state  <= one_state_buffer;
				--address_done  <= '1';
			end if;

--------------------------------------------------------------------------------
-- one pixel with 2 kernel weights, totally 8 cases
--------------------------------------------------------------------------------


			when two_state_01  => 
			if (mac_control_enable = '1' ) then 
				if (two_index = 1) then 
					next_state  <= done;
					address_done  <= '1';
				elsif ( two_index = 0) then
					next_state  <= two_state_01;
				end if;
			end if;

			when two_state_04  => 
			if (mac_control_enable = '1' ) then 
				if (two_index = 1) then 
					next_state  <= done;
					address_done  <= '1';
				elsif ( two_index = 0) then
					next_state  <= two_state_04;
				end if;
			end if;

			when two_state_10  => 
			if (mac_control_enable = '1' ) then 
				if (two_index = 1) then 
					next_state  <= done;
					address_done  <= '1';
				elsif ( two_index = 0) then
					next_state  <= two_state_10;
				end if;
			end if;

			when two_state_15  => 
			if (mac_control_enable = '1' ) then 
				if (two_index = 1) then 
					next_state  <= done;
					address_done  <= '1';
				elsif ( two_index = 0) then
					next_state  <= two_state_15;
				end if;
			end if;

			when two_state_20  => 
			if (mac_control_enable = '1' ) then 
				if (two_index = 1) then 
					next_state  <= done;
					address_done  <= '1';
				elsif ( two_index = 0) then
					next_state  <= two_state_20;
				end if;
			end if;

			when two_state_25  => 
			if (mac_control_enable = '1' ) then 
				if (two_index = 1) then 
					next_state  <= done;
					address_done  <= '1';
				elsif ( two_index = 0) then
					next_state  <= two_state_25;
				end if;
			end if;

			when two_state_31  => 
			if (mac_control_enable = '1' ) then 
				if (two_index = 1) then 
					next_state  <= done;
					address_done  <= '1';
				elsif ( two_index = 0) then
					next_state  <= two_state_31;
				end if;
			end if;

			when two_state_34  => 
			if (mac_control_enable = '1' ) then 
				if (two_index = 1) then 
					next_state  <= done;
					address_done  <= '1';
				elsif ( two_index = 0) then
					next_state  <= two_state_34;
				end if;
			end if;
--------------------------------------------------------------------------------
--  one pixel with 3 kernel weights, totally 2 cases 
--------------------------------------------------------------------------------

			when three_state_02  => 
			if (mac_control_enable = '1') then
				if (three_index = 3) then 
					next_state  <= done;
					address_done  <= '1';
				elsif ( three_index < 3) then
					next_state  <= three_state_02;
				end if;
			end if;

			when three_state_32  => 
			if (mac_control_enable = '1') then
				if (three_index = 3) then 
					next_state  <= done;
					address_done  <= '1';
				elsif ( three_index < 3) then
					next_state  <= three_state_32;
				end if;
			end if;

--------------------------------------------------------------------------------
-- one pixel with 4 kernel weights, totally 4 cases
--------------------------------------------------------------------------------


			when four_state_11  => 
			if (mac_control_enable = '1') then
				if (four_index = 3) then
					next_state  <= done;
					address_done  <= '1';
				elsif ( four_index < 3) then
					next_state  <= four_state_11;
				end if;
			end if;

			when four_state_14  => 
			if (mac_control_enable = '1') then
				if (four_index = 3) then 
					next_state  <= done;
					address_done  <= '1';
				elsif ( four_index < 3) then
					next_state  <= four_state_14;
				end if;
			end if;

			when four_state_21  => 
			if (mac_control_enable = '1') then
				if (four_index = 3) then 
					next_state  <= done;
					address_done  <= '1';
				elsif ( four_index < 3) then
					next_state  <= four_state_21;
				end if;
			end if;

			when four_state_24  => 
			if (mac_control_enable = '1') then
				if (four_index = 3) then 
					next_state  <= done;
					address_done  <= '1';
				elsif ( four_index < 3) then
					next_state  <= four_state_24;
				end if;
			end if;

--------------------------------------------------------------------------------
-- one pixel with 4 kernel weights, totally 2 cases
--------------------------------------------------------------------------------



			when six_state_up2  =>
			if (mac_control_enable = '1') then
				if (six_index = 6) then 
					next_state  <= done;
					address_done  <= '1';
				elsif ( six_index < 6) then
					next_state  <= six_state_up2;
				end if;
			end if;

			when six_state_down2  =>
			if (mac_control_enable = '1') then
				if (six_index = 6) then 
					next_state  <= done;
					address_done  <= '1';
				elsif ( six_index < 6) then
					next_state  <= six_state_down2;
				end if;
			end if;

			when new_stripe  => 
				if (mac_control_enable = '1') then
					
						next_state  <= mac_prepare;
						address_done  <= '1';
				end if;

			when done  => 
				if (mac_control_enable = '1') then
					if (mac_control_compute_done = '1') then 
						next_state  <= mac_prepare;
					end if;
				end if;

			
	end case;

	end process future_state_proc;


--------------------------------------------------------------------------------
-- output network
--------------------------------------------------------------------------------


	output_network: process(current_state,index)
	begin

			case current_state is

				when reset => 
					two_index    <= -1;
					three_index  <= -1;
					four_index   <= -1;
					six_index    <= -1;
					kernel_address  <= 0;
					kernel_address_ready  <= 0;
					layer_addition  <= 1;
					control_kernel_number  <= 0;

				when mac_start  => 

				when new_stripe  => 

				when one_state_buffer  => 

				when done  => 
					kernel_address_ready  <= 0;

				when mac_prepare  => 
					two_index    <= -1;
					three_index  <= -1;
					four_index   <= -1;
					six_index    <= -1;
					kernel_address  <= 0;
					kernel_address_ready  <= 0;
					layer_addition  <= 1;
					control_kernel_number  <= 0;
					

				when one_state_00  => 
					kernel_address  <=  kernel_address + 9 * z_reg;
					kernel_address_ready  <= 1;
					control_kernel_number  <= 1;


				when one_state_05  => 
					kernel_address  <=  kernel_address + 2 + 9 * z_reg;
					kernel_address_ready  <= 1;
					control_kernel_number  <= 1;

				when one_state_30  => 
					kernel_address  <=  kernel_address + 6 + 9 * z_reg;
					kernel_address_ready  <= 1;
					control_kernel_number  <= 1;

				when one_state_35  => 
					kernel_address  <=  kernel_address + 8 + 9 * z_reg;
					kernel_address_ready  <= 1;
					control_kernel_number  <= 1;

				when two_state_01  => 
					if ( layer_addition = 1) then
					kernel_address  <=  kernel_address  + 9 * z_reg;
					else
					kernel_address  <=  kernel_address + 1 ;
					end if;
					layer_addition  <= 0;
					two_index  <= two_index + 1;
					kernel_address_ready  <= 1;
					control_kernel_number  <= 2;

				when two_state_04  => 
					if ( layer_addition = 1) then
					kernel_address  <=  kernel_address + 1 + 9 * z_reg;
					else
					kernel_address  <=  kernel_address + 1  ;
					end if;
					layer_addition  <= 0;
					two_index  <= two_index + 1;
					kernel_address_ready  <= 1;
					control_kernel_number  <= 2;

				when two_state_10  => 
					if ( layer_addition = 1) then
					kernel_address  <=  kernel_address + 9 * z_reg;
					else
					kernel_address  <=  kernel_address + 3  ;
					end if;
					layer_addition  <= 0;
					two_index  <= two_index + 1;
					kernel_address_ready  <= 1;
					control_kernel_number  <= 2;

				when two_state_15  => 
					if ( layer_addition = 1) then
					kernel_address  <=  kernel_address + 2 + 9 * z_reg;
					else
					kernel_address  <=  kernel_address + 3  ;
					end if;
					layer_addition  <= 0;
					two_index  <= two_index + 1;
					kernel_address_ready  <= 1;
					control_kernel_number  <= 2;

				when two_state_20  => 
					if ( layer_addition = 1) then
					kernel_address  <=  kernel_address + 3 + 9 * z_reg;
					else
					kernel_address  <=  kernel_address + 3  ;
					end if;
					layer_addition  <= 0;
					two_index  <= two_index + 1;
					kernel_address_ready  <= 1;
					control_kernel_number  <= 2;

				when two_state_25  => 
					if ( layer_addition = 1) then
					kernel_address  <=  kernel_address + 5 + 9 * z_reg;
					else
					kernel_address  <=  kernel_address + 3  ;
					end if;
					layer_addition  <= 0;
					two_index  <= two_index + 1;
					kernel_address_ready  <= 1;
					control_kernel_number  <= 2;

				when two_state_31  => 
					if ( layer_addition = 1) then
					kernel_address  <=  kernel_address + 6 + 9 * z_reg;
					else
					kernel_address  <=  kernel_address + 1  ;
					end if;
					layer_addition  <= 0;
					two_index  <= two_index + 1;
					kernel_address_ready  <= 1;
					control_kernel_number  <= 2;

				when two_state_34  => 
					if ( layer_addition = 1) then
					kernel_address  <=  kernel_address + 7 + 9 * z_reg;
					else
					kernel_address  <=  kernel_address + 1  ;
					end if;
					layer_addition  <= 0;
					two_index  <= two_index + 1;
					kernel_address_ready  <= 1;
					control_kernel_number  <= 2;

				when three_state_02  => 
					if ( three_index = -1) then
					kernel_address  <=  kernel_address + 9 * z_reg;
					elsif ( three_index = 0) then 
					kernel_address  <=  kernel_address + 1  ;
					elsif ( three_index = 1) then 
					kernel_address  <=  kernel_address + 1  ;
					end if;
					three_index  <= three_index + 1;
					kernel_address_ready  <= 1;
					control_kernel_number  <= 3;

				when three_state_32  => 
					if ( three_index = -1) then
					kernel_address  <=  kernel_address + 6 + 9 * z_reg;
					elsif ( three_index = 0) then 
					kernel_address  <=  kernel_address + 1  ;
					elsif ( three_index = 1) then 
					kernel_address  <=  kernel_address + 1  ;
					end if;
					three_index  <= three_index + 1;
					kernel_address_ready  <= 1;
					control_kernel_number  <= 3;

				when four_state_11  => 
					if ( four_index = -1) then
					kernel_address  <=  kernel_address + 9 * z_reg;
					elsif ( four_index = 0) then 
					kernel_address  <=  kernel_address + 1  ;
					elsif ( four_index = 1) then 
					kernel_address  <=  kernel_address + 2  ;
					elsif ( four_index = 2) then 
					kernel_address  <=  kernel_address + 1  ;
					end if;
					four_index  <= four_index + 1;
					kernel_address_ready  <= 1;
					control_kernel_number  <= 4;

				when four_state_14  => 
					if ( four_index = -1) then
					kernel_address  <=  kernel_address + 1 + 9 * z_reg;
					elsif ( four_index = 0) then 
					kernel_address  <=  kernel_address + 1  ;
					elsif ( four_index = 1) then 
					kernel_address  <=  kernel_address + 2  ;
					elsif ( four_index = 2) then 
					kernel_address  <=  kernel_address + 1  ;
					end if;
					four_index  <= four_index + 1;
					kernel_address_ready  <= 1;
					control_kernel_number  <= 4;

				when four_state_21  => 
					if ( four_index = -1) then
					kernel_address  <=  kernel_address + 3 + 9 * z_reg;
					elsif ( four_index = 0) then 
					kernel_address  <=  kernel_address + 1  ;
					elsif ( four_index = 1) then 
					kernel_address  <=  kernel_address + 2  ;
					elsif ( four_index = 2) then 
					kernel_address  <=  kernel_address + 1  ;
					end if;
					four_index  <= four_index + 1;
					kernel_address_ready  <= 1;
					control_kernel_number  <= 4;

				when four_state_24  => 
					if ( four_index = -1) then
					kernel_address  <=  kernel_address + 4 + 9 * z_reg;
					elsif ( four_index = 0) then 
					kernel_address  <=  kernel_address + 1  ;
					elsif ( four_index = 1) then 
					kernel_address  <=  kernel_address + 2  ;
					elsif ( four_index = 2) then 
					kernel_address  <=  kernel_address + 1  ;
					end if;
					four_index  <= four_index + 1;
					kernel_address_ready  <= 1;
					control_kernel_number  <= 4;

				when six_state_up2  => 
					if ( six_index = -1) then
					kernel_address  <=  kernel_address + 9 * z_reg;
					elsif ( six_index = 0) then 
					kernel_address  <=  kernel_address + 1  ;
					elsif ( six_index = 1) then 
					kernel_address  <=  kernel_address + 1  ;
					elsif ( six_index = 2) then 
					kernel_address  <=  kernel_address + 1  ;
					elsif ( six_index = 3) then 
					kernel_address  <=  kernel_address + 1  ;
					elsif ( six_index = 4) then 
					kernel_address  <=  kernel_address + 1  ;
					end if;
					six_index  <= six_index + 1;
					kernel_address_ready  <= 1;
					control_kernel_number  <= 6;

				when six_state_down2  => 
					if ( six_index = -1) then
					kernel_address  <=  kernel_address + 3 + 9 * z_reg;
					elsif ( six_index = 0) then 
					kernel_address  <=  kernel_address + 1  ;
					elsif ( six_index = 1) then 
					kernel_address  <=  kernel_address + 1  ;
					elsif ( six_index = 2) then 
					kernel_address  <=  kernel_address + 1  ;
					elsif ( six_index = 3) then 
					kernel_address  <=  kernel_address + 1  ;
					elsif ( six_index = 4) then 
					kernel_address  <=  kernel_address + 1  ;
					end if;
					six_index  <= six_index + 1;
					kernel_address_ready  <= 1;
					control_kernel_number  <= 6;

			end case;

	end process;

end behavioral;
