LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;

 -------------------------------------------------------------------------------
 -- Function:
 -- 1. SRAM, storing all the data come from input_bus
 -- 2. one read port, one write port
 -- 3. The data is written and read both at the rising edge of the clock

 -- Notes:
 -- 1. The size is set at a large number, but still needs to be corrected
 -- 2. This file has an individual testbench
 -- 3. Last test on 11 Feb 2022.
 -------------------------------------------------------------------------------
 
entity locator_sram is
                          
    Port ( 

        clk                       : in  STD_LOGIC;
        reset                     : in  STD_LOGIC;
        enable                     : in std_logic;
        fsm0_data_valid         : in integer;
        fsm1_data_valid         : in integer;
        fsm2_data_valid         : in integer;
        fsm3_data_valid         : in integer;
        fsm0_data         : in  STD_LOGIC_VECTOR (SM_segment_bit - 1 downto 0);
        fsm1_data         : in  STD_LOGIC_VECTOR (SM_segment_bit - 1 downto 0);
        fsm2_data         : in  STD_LOGIC_VECTOR (SM_segment_bit - 1 downto 0);
        fsm3_data         : in  STD_LOGIC_VECTOR (SM_segment_bit - 1 downto 0);
        fsm0_x    : in integer; 
        fsm0_y    : in integer; 
        fsm0_z    : in integer; 
        fsm1_x    : in integer; 
        fsm1_y    : in integer; 
        fsm1_z    : in integer; 
        fsm2_x    : in integer; 
        fsm2_y    : in integer; 
        fsm2_z    : in integer; 
        fsm3_x    : in integer; 
        fsm3_y    : in integer; 
        fsm3_z    : in integer; 
        compute_done     : in std_logic;
        read_enable : in STD_LOGIC;
        write_enable : in STD_LOGIC;

        locator_data_valid   : out std_logic;
        locator_data    : out integer;
        locator_x       : out integer;
        locator_y       : out integer;
        locator_z       : out integer
        );
end locator_sram;
 
architecture Behavioral of locator_sram is

    --type Memory_Array is array (0 to (2 ** SIZE_sram_address) - 1) of STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
    type Memory_Array is array (0 to 700 ) of integer;  --for test, since the big array slows down the simulation

    signal Memory : Memory_Array;
    signal index : integer;
    signal fsm0_data_conv,fsm1_data_conv,fsm2_data_conv,fsm3_data_conv : integer;
    signal locator_data_valid_buffer : std_logic;
begin

fsm0_data_conv  <= to_integer(unsigned(fsm0_data));
fsm1_data_conv  <= to_integer(unsigned(fsm1_data));
fsm2_data_conv  <= to_integer(unsigned(fsm2_data));
fsm3_data_conv  <= to_integer(unsigned(fsm3_data));
 

    process(clk)
    begin
        if reset = '1' then
            index  <= 0;
        elsif rising_edge(clk) then
            if compute_done = '1' then 
                if index < 188 then 
                index  <= index + 4;
                elsif index = 188 then
                index  <= 0;
                end if;
            end if;
        end if;
    end process ;


    -- Read process
    process (clk)
    begin
        if reset = '1' then
            locator_data_valid  <= '0';
            locator_data_valid_buffer  <= '0';

        elsif rising_edge(clk) then
            if enable = '1' then        
                if  read_enable  = '1' then
                    -- Read Memory
                    locator_data <= Memory(index);
                    locator_x <= Memory(index + 1);
                    locator_y <= Memory(index + 2);
                    locator_z <= Memory(index + 3);
                    locator_data_valid_buffer  <= '1';
                    locator_data_valid  <= locator_data_valid_buffer;
                else 
                    locator_data_valid  <= '0';
                    locator_data_valid_buffer  <= '0';
                    locator_data <= 0;
                    locator_x <= 0;
                    locator_y <= 0;
                    locator_z <= 0;
                end if;
            end if;      
        end if;
    end process;
 
    -- Write process
    process (clk)
    variable sram_write_address : integer range 0 to 710;   
  -- --  integer range needs to be changed if change the number of sram banks   
                                                              
  -- --  1st, this value should be set a little bit larger otherwise it will stop the simulation
                                                              
  -- --  2nd, if bank number = 4; the available address is 0 to 65535, so here the range should be at least 65536, but 70000 better
                                                              
  -- --  3rd, if bank number = 8; the available address is 0 to 65535*2, so here better should be 140000;
  
    begin
        if reset = '1' then
                -- Clear Memory on sram_reset
                Memory <= (others => 0);
                sram_write_address := 0;   --value needs to be changed if change the number of sram banks
                                              -- if bank number = 4; we use 0 to 65535
        elsif rising_edge(clk) then

            if ((enable = '1') and (sram_write_address < 700) and write_enable = '1') then
                    if (fsm0_data_valid = 2) then
                    Memory(sram_write_address) <= fsm0_data_conv;
                    sram_write_address := sram_write_address + 1;
                    Memory(sram_write_address) <= fsm0_x;
                    sram_write_address := sram_write_address + 1;
                    Memory(sram_write_address) <= fsm0_y;
                    sram_write_address := sram_write_address + 1;
                    Memory(sram_write_address) <= fsm0_z;
                    sram_write_address := sram_write_address + 1;
                    end if;      

                    if (fsm1_data_valid = 2) then
                    Memory(sram_write_address) <= fsm1_data_conv;
                    sram_write_address := sram_write_address + 1;
                    Memory(sram_write_address) <= fsm1_x;
                    sram_write_address := sram_write_address + 1;
                    Memory(sram_write_address) <= fsm1_y;
                    sram_write_address := sram_write_address + 1;
                    Memory(sram_write_address) <= fsm1_z;
                    sram_write_address := sram_write_address + 1;
                    end if;

                    if (fsm2_data_valid = 2) then
                    Memory(sram_write_address) <= fsm2_data_conv;
                    sram_write_address := sram_write_address + 1;
                    Memory(sram_write_address) <= fsm2_x;
                    sram_write_address := sram_write_address + 1;
                    Memory(sram_write_address) <= fsm2_y;
                    sram_write_address := sram_write_address + 1;
                    Memory(sram_write_address) <= fsm2_z;
                    sram_write_address := sram_write_address + 1;
                    end if;

                    if (fsm3_data_valid = 2) then
                    Memory(sram_write_address) <= fsm3_data_conv;
                    sram_write_address := sram_write_address + 1;
                    Memory(sram_write_address) <= fsm3_x;
                    sram_write_address := sram_write_address + 1;
                    Memory(sram_write_address) <= fsm3_y;
                    sram_write_address := sram_write_address + 1;
                    Memory(sram_write_address) <= fsm3_z;
                    sram_write_address := sram_write_address + 1;
                    end if;

                 
          

                    if  sram_write_address > 700 then
                        sram_write_address := 700;      
                    end if;
            end if;
        end if;
        
    end process;
end Behavioral;