LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
use work.func_external.all;

entity locator_mux is 
	port( 
		fsm0_data   : in std_logic_vector ( SM_segment_bit-1 downto 0 );
		fsm1_data   : in std_logic_vector ( SM_segment_bit-1 downto 0 );
		fsm2_data   : in std_logic_vector ( SM_segment_bit-1 downto 0 );
		fsm3_data   : in std_logic_vector ( SM_segment_bit-1 downto 0 );
		fsm0_valid  : in integer;
		fsm1_valid  : in integer;
		fsm2_valid  : in integer;
		fsm3_valid  : in integer;
		fsm0_x 		: in integer;
		fsm0_y 		: in integer;
		fsm0_z 		: in integer;
		fsm1_x 		: in integer;
		fsm1_y 		: in integer;
		fsm1_z 		: in integer;
		fsm2_x 		: in integer;
		fsm2_y 		: in integer;
		fsm2_z 		: in integer;
		fsm3_x 		: in integer;
		fsm3_y 		: in integer;
		fsm3_z 		: in integer;
		loc_compute_done : in std_logic;
		locator_clk  : in std_logic;
		locator_en   : in std_logic;
		locator_rst  : in std_logic;

		locator_data_out : out integer;
		data_valid : out std_logic;
		stop_IDP : out std_logic;
		pixel_x : out integer;
		pixel_y : out integer;
		pixel_z : out integer
	 );
end locator_mux;

architecture bhv of locator_mux is

signal control_signal : integer;
--signal pixel_valid : integer;
signal index : integer;
signal fsm0_data_reg, fsm0_data_reg_reg, fsm0_data_reg_reg_reg  : std_logic_vector ( SM_segment_bit-1 downto 0 );
signal fsm1_data_reg, fsm1_data_reg_reg, fsm1_data_reg_reg_reg  : std_logic_vector ( SM_segment_bit-1 downto 0 );
signal fsm2_data_reg, fsm2_data_reg_reg, fsm2_data_reg_reg_reg  : std_logic_vector ( SM_segment_bit-1 downto 0 );
signal fsm3_data_reg, fsm3_data_reg_reg, fsm3_data_reg_reg_reg  : std_logic_vector ( SM_segment_bit-1 downto 0 );
signal fsm0_valid_reg, fsm0_valid_reg_reg, fsm0_valid_reg_reg_reg  : integer;
signal fsm1_valid_reg, fsm1_valid_reg_reg, fsm1_valid_reg_reg_reg  : integer;
signal fsm2_valid_reg, fsm2_valid_reg_reg, fsm2_valid_reg_reg_reg  : integer;
signal fsm3_valid_reg, fsm3_valid_reg_reg, fsm3_valid_reg_reg_reg  : integer;
signal fsm0_x_reg, fsm0_x_reg_reg, fsm0_x_reg_reg_reg  : integer;
signal fsm0_y_reg, fsm0_y_reg_reg, fsm0_y_reg_reg_reg  : integer;
signal fsm0_z_reg, fsm0_z_reg_reg, fsm0_z_reg_reg_reg  : integer;
signal fsm1_x_reg, fsm1_x_reg_reg, fsm1_x_reg_reg_reg  : integer;
signal fsm1_y_reg, fsm1_y_reg_reg, fsm1_y_reg_reg_reg  : integer;
signal fsm1_z_reg, fsm1_z_reg_reg, fsm1_z_reg_reg_reg  : integer;
signal fsm2_x_reg, fsm2_x_reg_reg, fsm2_x_reg_reg_reg  : integer;
signal fsm2_y_reg, fsm2_y_reg_reg, fsm2_y_reg_reg_reg  : integer;
signal fsm2_z_reg, fsm2_z_reg_reg, fsm2_z_reg_reg_reg  : integer;
signal fsm3_x_reg, fsm3_x_reg_reg, fsm3_x_reg_reg_reg  : integer;
signal fsm3_y_reg, fsm3_y_reg_reg, fsm3_y_reg_reg_reg  : integer;
signal fsm3_z_reg, fsm3_z_reg_reg, fsm3_z_reg_reg_reg  : integer;
signal pixel_value : std_logic_vector ( SM_segment_bit-1 downto 0);

begin

locator_data_out  <= to_integer(unsigned(pixel_value));


stop_IDP_unit : process (locator_clk,locator_rst)
begin 

	if (locator_rst = '1') then 
		stop_IDP  <= '0';
	elsif (rising_edge(locator_clk)) then
		if ( fsm0_valid = 2 or fsm1_valid = 2 or fsm2_valid = 2 or fsm3_valid = 2 ) then
			stop_IDP  <= '1';
		end if;
	end if;

end process;



mac_compute_done_accumulation : process(locator_clk,locator_rst)
begin

	if (locator_rst = '1') then
		index  <= 0;

	elsif (rising_edge(locator_clk)) then

		if ( index < 3) then 
			if (loc_compute_done = '1') then
				index  <= index + 1;
			end if;
		else
		 	index  <= 0;
		end if;

	end if;

end process;

data_storage_process : process (locator_clk,locator_rst)
begin
	if (locator_rst = '1') then

			fsm0_data_reg     <=  ( others => '0');
			fsm1_data_reg     <=  ( others => '0');
			fsm2_data_reg     <=  ( others => '0');
			fsm3_data_reg     <=  ( others => '0');
			fsm0_valid_reg     <=  0;
			fsm1_valid_reg     <=  0;
			fsm2_valid_reg     <=  0;
			fsm3_valid_reg     <=  0;
			fsm0_x_reg     <=  0;
			fsm0_y_reg     <=  0;
			fsm0_z_reg     <=  0;
			fsm1_x_reg     <=  0;
			fsm1_y_reg     <=  0;
			fsm1_z_reg     <=  0;
			fsm2_x_reg     <=  0;
			fsm2_y_reg     <=  0;
			fsm2_z_reg     <=  0;
			fsm3_x_reg     <=  0;
			fsm3_y_reg     <=  0;
			fsm3_z_reg     <=  0;

			fsm0_data_reg_reg     <=  ( others => '0');
			fsm1_data_reg_reg     <=  ( others => '0');
			fsm2_data_reg_reg     <=  ( others => '0');
			fsm3_data_reg_reg     <=  ( others => '0');
			fsm0_valid_reg_reg     <=  0;
			fsm1_valid_reg_reg     <=  0;
			fsm2_valid_reg_reg     <=  0;
			fsm3_valid_reg_reg     <=  0;
			fsm0_x_reg_reg     <=  0;
			fsm0_y_reg_reg     <=  0;
			fsm0_z_reg_reg     <=  0;
			fsm1_x_reg_reg     <=  0;
			fsm1_y_reg_reg     <=  0;
			fsm1_z_reg_reg     <=  0;
			fsm2_x_reg_reg     <=  0;
			fsm2_y_reg_reg     <=  0;
			fsm2_z_reg_reg     <=  0;
			fsm3_x_reg_reg     <=  0;
			fsm3_y_reg_reg     <=  0;
			fsm3_z_reg_reg     <=  0;

			fsm0_data_reg_reg_reg     <=  ( others => '0');
			fsm1_data_reg_reg_reg     <=  ( others => '0');
			fsm2_data_reg_reg_reg     <=  ( others => '0');
			fsm3_data_reg_reg_reg     <=  ( others => '0');
			fsm0_valid_reg_reg_reg     <=  0;
			fsm1_valid_reg_reg_reg     <=  0;
			fsm2_valid_reg_reg_reg     <=  0;
			fsm3_valid_reg_reg_reg     <=  0;
			fsm0_x_reg_reg_reg     <=  0;
			fsm0_y_reg_reg_reg     <=  0;
			fsm0_z_reg_reg_reg     <=  0;
			fsm1_x_reg_reg_reg     <=  0;
			fsm1_y_reg_reg_reg     <=  0;
			fsm1_z_reg_reg_reg     <=  0;
			fsm2_x_reg_reg_reg     <=  0;
			fsm2_y_reg_reg_reg     <=  0;
			fsm2_z_reg_reg_reg     <=  0;
			fsm3_x_reg_reg_reg     <=  0;
			fsm3_y_reg_reg_reg     <=  0;
			fsm3_z_reg_reg_reg     <=  0;

	elsif (rising_edge (locator_clk)) then
		if ( stop_IDP = '0') then
			fsm0_data_reg    	<= fsm0_data; 
			fsm1_data_reg    	<= fsm1_data; 
			fsm2_data_reg    	<= fsm2_data; 
			fsm3_data_reg    	<= fsm3_data; 
			fsm0_valid_reg    	<= fsm0_valid; 
			fsm1_valid_reg    	<= fsm1_valid; 
			fsm2_valid_reg    	<= fsm2_valid; 
			fsm3_valid_reg    	<= fsm3_valid; 
			fsm0_x_reg    		<= fsm0_x; 
			fsm0_y_reg    		<= fsm0_y; 
			fsm0_z_reg    		<= fsm0_z; 
			fsm1_x_reg    		<= fsm1_x; 
			fsm1_y_reg    		<= fsm1_y; 
			fsm1_z_reg    		<= fsm1_z; 
			fsm2_x_reg    		<= fsm2_x; 
			fsm2_y_reg    		<= fsm2_y; 
			fsm2_z_reg    		<= fsm2_z; 
			fsm3_x_reg    		<= fsm3_x; 
			fsm3_y_reg    		<= fsm3_y; 
			fsm3_z_reg    		<= fsm3_z; 

			fsm0_data_reg_reg    	<= fsm0_data_reg; 
			fsm1_data_reg_reg    	<= fsm1_data_reg; 
			fsm2_data_reg_reg    	<= fsm2_data_reg; 
			fsm3_data_reg_reg    	<= fsm3_data_reg; 
			fsm0_valid_reg_reg    	<= fsm0_valid_reg; 
			fsm1_valid_reg_reg    	<= fsm1_valid_reg; 
			fsm2_valid_reg_reg    	<= fsm2_valid_reg; 
			fsm3_valid_reg_reg    	<= fsm3_valid_reg; 
			fsm0_x_reg_reg    		<= fsm0_x_reg; 
			fsm0_y_reg_reg    		<= fsm0_y_reg; 
			fsm0_z_reg_reg    		<= fsm0_z_reg; 
			fsm1_x_reg_reg    		<= fsm1_x_reg; 
			fsm1_y_reg_reg    		<= fsm1_y_reg; 
			fsm1_z_reg_reg    		<= fsm1_z_reg; 
			fsm2_x_reg_reg    		<= fsm2_x_reg; 
			fsm2_y_reg_reg    		<= fsm2_y_reg; 
			fsm2_z_reg_reg    		<= fsm2_z_reg; 
			fsm3_x_reg_reg    		<= fsm3_x_reg; 
			fsm3_y_reg_reg    		<= fsm3_y_reg; 
			fsm3_z_reg_reg    		<= fsm3_z_reg; 

			fsm0_data_reg_reg_reg    	<= fsm0_data_reg_reg; 
			fsm1_data_reg_reg_reg    	<= fsm1_data_reg_reg; 
			fsm2_data_reg_reg_reg    	<= fsm2_data_reg_reg; 
			fsm3_data_reg_reg_reg    	<= fsm3_data_reg_reg; 
			fsm0_valid_reg_reg_reg    	<= fsm0_valid_reg_reg; 
			fsm1_valid_reg_reg_reg    	<= fsm1_valid_reg_reg; 
			fsm2_valid_reg_reg_reg    	<= fsm2_valid_reg_reg; 
			fsm3_valid_reg_reg_reg    	<= fsm3_valid_reg_reg; 
			fsm0_x_reg_reg_reg    		<= fsm0_x_reg_reg; 
			fsm0_y_reg_reg_reg    		<= fsm0_y_reg_reg; 
			fsm0_z_reg_reg_reg    		<= fsm0_z_reg_reg; 
			fsm1_x_reg_reg_reg    		<= fsm1_x_reg_reg; 
			fsm1_y_reg_reg_reg    		<= fsm1_y_reg_reg; 
			fsm1_z_reg_reg_reg    		<= fsm1_z_reg_reg; 
			fsm2_x_reg_reg_reg    		<= fsm2_x_reg_reg; 
			fsm2_y_reg_reg_reg    		<= fsm2_y_reg_reg; 
			fsm2_z_reg_reg_reg    		<= fsm2_z_reg_reg; 
			fsm3_x_reg_reg_reg    		<= fsm3_x_reg_reg; 
			fsm3_y_reg_reg_reg    		<= fsm3_y_reg_reg; 
			fsm3_z_reg_reg_reg    		<= fsm3_z_reg_reg; 
			end if;

	end if;

end process;


data_select_process :process (locator_rst,locator_clk )
begin
	if(locator_rst = '1') then
		pixel_value  <= (others => '0');
		pixel_x  	 <= 0;
		pixel_y  	 <= 0;
		pixel_z  	 <= 0;
		data_valid   <= '0';
	elsif ( rising_edge (locator_clk)) then 
		if(locator_en = '1') then
			if (stripe_index = 0) then  
			--if(loc_compute_done = '1') then
				if( fsm0_valid_reg /= 2 and  fsm1_valid_reg /= 2 and  fsm2_valid_reg /= 2 and  fsm3_valid_reg /= 2 ) then
					--stop_IDP  <= '0';
					--data_valid  <= '0';
					stripe_index  <= 1;

				elsif( fsm0_valid_reg /= 2 and  fsm1_valid_reg /= 2 and  fsm2_valid_reg /= 2 and  fsm3_valid_reg = 2 ) then 
				 --fsm3 is valid, others are zero pixel

					--if (index = 0) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm3_data_reg;
						pixel_x  	 <= fsm3_x_reg;
						pixel_y  	 <= fsm3_y_reg;
						pixel_z  	 <= fsm3_z_reg;
						stripe_index  <= 1;
						--data_valid   <= '1'; 
						--pixel_valid  <= fsm3_valid_reg;
					--elsif (index = 1) then
						--stop_IDP  <= '0';
						--data_valid  <= '0';
					--end if;

				elsif( fsm0_valid_reg /= 2 and  fsm1_valid_reg /= 2 and  fsm2_valid_reg = 2 and  fsm3_valid_reg /= 2 ) then
				--fsm2 is valid, others are zero pixel value

					--if (index = 0) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm2_data_reg;
						pixel_x  	 <= fsm2_x_reg;
						pixel_y  	 <= fsm2_y_reg;
						pixel_z  	 <= fsm2_z_reg;
						stripe_index  <= 1;
						--data_valid  <= '1';
						--pixel_valid  <= fsm2_valid_reg;
					--elsif (index = 1) then
						--stop_IDP  <= '0';
						--data_valid  <= '0';
					--end if;

				elsif( fsm0_valid_reg /= 2 and  fsm1_valid_reg = 2 and  fsm2_valid_reg /= 2 and  fsm3_valid_reg /= 2 ) then
				--fsm1 is valid,  fsm0/2/3 are zero pixel

					--if (index = 0) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm1_data_reg;
						pixel_x  	 <= fsm1_x_reg;
						pixel_y  	 <= fsm1_y_reg;
						pixel_z  	 <= fsm1_z_reg;
						stripe_index  <= 1;
						--pixel_valid  <= fsm1_valid_reg;
						--data_valid  <= '1';

					--elsif (index = 1) then
						--stop_IDP  <= '0';
						--data_valid  <= '0';
					--end if;

				elsif( fsm0_valid_reg = 2 and  fsm1_valid_reg /= 2 and  fsm2_valid_reg /= 2 and  fsm3_valid_reg /= 2 ) then
				--fsm0 is valid,  fsm1/2/3 are zero pixel

					--if (index = 0) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm0_data_reg;
						pixel_x  	 <= fsm0_x_reg;
						pixel_y  	 <= fsm0_y_reg;
						pixel_z  	 <= fsm0_z_reg;
						stripe_index  <= 1;
						--pixel_valid  <= fsm0_valid_reg;
						--data_valid  <= '1';

					--elsif (index = 1) then
						--data_valid  <= '0';
						--stop_IDP  <= '0';
					--end if;
--------------------------------------------------------------------------------
-- two valid in one stripe
--------------------------------------------------------------------------------

				elsif( fsm0_valid_reg /= 2 and  fsm1_valid_reg /= 2 and  fsm2_valid_reg = 2 and  fsm3_valid_reg = 2 ) then
				--fsm2/3 are valid,  fsm0/1 are zero pixels

					if (index = 0) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm2_data_reg;
						pixel_x  	 <= fsm2_x_reg;
						pixel_y  	 <= fsm2_y_reg;
						pixel_z  	 <= fsm2_z_reg;
						--data_valid  <= '1';

						--pixel_valid  <= fsm2_valid_reg;
					elsif (index = 1) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm3_data_reg;
						pixel_x  	 <= fsm3_x_reg;
						pixel_y  	 <= fsm3_y_reg;
						pixel_z  	 <= fsm3_z_reg;
						stripe_index  <= 1;
						--data_valid  <= '1';
						--pixel_valid  <= fsm3_valid_reg;
					--elsif (index = 2) then
						--stop_IDP  <= '0';
						--data_valid  <= '0';
					--end if;

				elsif( fsm0_valid_reg /= 2 and  fsm1_valid_reg = 2 and  fsm2_valid_reg /= 2 and  fsm3_valid_reg = 2 ) then
				--fsm1/3 are valid, fsm0/4 are zero pixels 

					if (index = 0) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm1_data_reg;
						pixel_x  	 <= fsm1_x_reg;
						pixel_y  	 <= fsm1_y_reg;
						pixel_z  	 <= fsm1_z_reg;
						--pixel_valid  <= fsm1_valid_reg;
						--data_valid  <= '1';

					elsif (index = 1) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm3_data_reg;
						pixel_x  	 <= fsm3_x_reg;
						pixel_y  	 <= fsm3_y_reg;
						pixel_z  	 <= fsm3_z_reg;
						stripe_index  <= 1;
						--data_valid  <= '1';
						--pixel_valid  <= fsm3_valid_reg;
					--elsif (index = 2) then
						--data_valid  <= '0';
						--stop_IDP  <= '0';
					--end if;

				elsif( fsm0_valid_reg = 2 and  fsm1_valid_reg /= 2 and  fsm2_valid_reg /= 2 and  fsm3_valid_reg = 2 ) then
				--fsm0/3  are valid,  fsm1/2 are zero pixels

					if (index = 0) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm0_data_reg;
						pixel_x  	 <= fsm0_x_reg;
						pixel_y  	 <= fsm0_y_reg;
						pixel_z  	 <= fsm0_z_reg;
						--pixel_valid  <= fsm0_valid_reg;
						--data_valid  <= '1';

					elsif (index = 1) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm3_data_reg;
						pixel_x  	 <= fsm3_x_reg;
						pixel_y  	 <= fsm3_y_reg;
						pixel_z  	 <= fsm3_z_reg;
						--data_valid  <= '1';
						--pixel_valid  <= fsm3_valid_reg;
					elsif (index = 2) then
						--data_valid  <= '0';
						--stop_IDP  <= '0';
					end if;

				elsif( fsm0_valid_reg /= 2 and  fsm1_valid_reg = 2 and  fsm2_valid_reg = 2 and  fsm3_valid_reg /= 2 ) then
				--fsm1/2 are valid, fsm0/3 are zero pixels

					if (index = 0) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm1_data_reg;
						pixel_x  	 <= fsm1_x_reg;
						pixel_y  	 <= fsm1_y_reg;
						pixel_z  	 <= fsm1_z_reg;
						--pixel_valid  <= fsm1_valid_reg;
						--data_valid  <= '1';

					elsif (index = 1) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm2_data_reg;
						pixel_x  	 <= fsm2_x_reg;
						pixel_y  	 <= fsm2_y_reg;
						pixel_z  	 <= fsm2_z_reg;
						--data_valid  <= '1';
						--pixel_valid  <= fsm2_valid_reg;
					elsif (index = 2) then
						--stop_IDP  <= '0';
						--data_valid  <= '0';
					end if;

				elsif( fsm0_valid_reg = 2 and  fsm1_valid_reg /= 2 and  fsm2_valid_reg = 2 and  fsm3_valid_reg /= 2 ) then
				--fsm0/2 are valid,  fsm1/3 are zero pixels

					if (index = 0) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm0_data_reg;
						pixel_x  	 <= fsm0_x_reg;
						pixel_y  	 <= fsm0_y_reg;
						pixel_z  	 <= fsm0_z_reg;
						--pixel_valid  <= fsm0_valid_reg;
						--data_valid  <= '1';

					elsif (index = 1) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm2_data_reg;
						pixel_x  	 <= fsm2_x_reg;
						pixel_y  	 <= fsm2_y_reg;
						pixel_z  	 <= fsm2_z_reg;
						--data_valid  <= '1';
						--pixel_valid  <= fsm2_valid_reg;
					elsif (index = 2) then
						--data_valid  <= '0';
						--stop_IDP  <= '0';
					end if;

				elsif( fsm0_valid_reg = 2 and  fsm1_valid_reg = 2 and  fsm2_valid_reg /= 2 and  fsm3_valid_reg /= 2 ) then
				--fsm0/1 are valid, fsm2/3 are zero pixels

					if (index = 0) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm0_data_reg;
						pixel_x  	 <= fsm0_x_reg;
						pixel_y  	 <= fsm0_y_reg;
						pixel_z  	 <= fsm0_z_reg;
						--pixel_valid  <= fsm0_valid_reg;
						--data_valid  <= '1';

					elsif (index = 1) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm1_data_reg;
						pixel_x  	 <= fsm1_x_reg;
						pixel_y  	 <= fsm1_y_reg;
						pixel_z  	 <= fsm1_z_reg;
						--data_valid  <= '1';
						--pixel_valid  <= fsm1_valid_reg;
					elsif (index = 2) then
						--data_valid  <= '0';
						--stop_IDP  <= '0';
					end if;
--------------------------------------------------------------------------------
-- three valid in one stripe
--------------------------------------------------------------------------------


				elsif( fsm0_valid_reg /= 2 and  fsm1_valid_reg = 2 and  fsm2_valid_reg = 2 and  fsm3_valid_reg = 2 ) then
				--fsm1/2/3 are valid,   fsm0 is zero pixel

					if (index = 0) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm1_data_reg;
						pixel_x  	 <= fsm1_x_reg;
						pixel_y  	 <= fsm1_y_reg;
						pixel_z  	 <= fsm1_z_reg;
						--pixel_valid  <= fsm1_valid_reg;
						--data_valid  <= '1';

					elsif (index = 1) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm2_data_reg;
						pixel_x  	 <= fsm2_x_reg;
						pixel_y  	 <= fsm2_y_reg;
						pixel_z  	 <= fsm2_z_reg;
						--data_valid  <= '1';
						--pixel_valid  <= fsm2_valid_reg;
					elsif (index = 2) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm3_data_reg;
						pixel_x  	 <= fsm3_x_reg;
						pixel_y  	 <= fsm3_y_reg;
						pixel_z  	 <= fsm3_z_reg;
						--data_valid  <= '1';
						--pixel_valid  <= fsm3_valid_reg;
					elsif (index = 3) then
						--stop_IDP  <= '0';
						--data_valid  <= '0';
					end if;

				elsif( fsm0_valid_reg = 2 and  fsm1_valid_reg /= 2 and  fsm2_valid_reg = 2 and  fsm3_valid_reg = 2 ) then
				--fsm0/2/3 are valid,  fsm1 is zero pixel

					if (index = 0) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm0_data_reg;
						pixel_x  	 <= fsm0_x_reg;
						pixel_y  	 <= fsm0_y_reg;
						pixel_z  	 <= fsm0_z_reg;
						--pixel_valid  <= fsm0_valid_reg;
						--data_valid  <= '1';

					elsif (index = 1) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm2_data_reg;
						pixel_x  	 <= fsm2_x_reg;
						pixel_y  	 <= fsm2_y_reg;
						pixel_z  	 <= fsm2_z_reg;
						--data_valid  <= '1';
						--pixel_valid  <= fsm2_valid_reg;
					elsif (index = 2) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm3_data_reg;
						pixel_x  	 <= fsm3_x_reg;
						pixel_y  	 <= fsm3_y_reg;
						pixel_z  	 <= fsm3_z_reg;
						--data_valid  <= '1';
						--pixel_valid  <= fsm3_valid_reg;
					elsif (index = 3) then
						--stop_IDP  <= '0';
						--data_valid  <= '0';
					end if;

				elsif( fsm0_valid_reg = 2 and  fsm1_valid_reg = 2 and  fsm2_valid_reg = 2 and  fsm3_valid_reg /= 2 ) then
				--fsm0/1/2 are valid,  fsm3 is zero pixel

					if (index = 0) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm0_data_reg;
						pixel_x  	 <= fsm0_x_reg;
						pixel_y  	 <= fsm0_y_reg;
						pixel_z  	 <= fsm0_z_reg;
						--pixel_valid  <= fsm0_valid_reg;
						--data_valid  <= '1';

					elsif (index = 1) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm1_data_reg;
						pixel_x  	 <= fsm1_x_reg;
						pixel_y  	 <= fsm1_y_reg;
						pixel_z  	 <= fsm1_z_reg;
						--data_valid  <= '1';
						--pixel_valid  <= fsm1_valid_reg;
					elsif (index = 2) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm2_data_reg;
						pixel_x  	 <= fsm2_x_reg;
						pixel_y  	 <= fsm2_y_reg;
						pixel_z  	 <= fsm2_z_reg;
						--data_valid  <= '1';
						--pixel_valid  <= fsm2_valid_reg;
					elsif (index = 3) then
						--stop_IDP  <= '0';
						--data_valid  <= '0';
					end if;

--------------------------------------------------------------------------------
-- four valid in one stripe
--------------------------------------------------------------------------------

				elsif( fsm0_valid_reg = 2 and  fsm1_valid_reg = 2 and  fsm2_valid_reg = 2 and  fsm3_valid_reg = 2 ) then
				-- all fsms are valid

					if (index = 0) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm0_data_reg;
						pixel_x  	 <= fsm0_x_reg;
						pixel_y  	 <= fsm0_y_reg;
						pixel_z  	 <= fsm0_z_reg;
						--pixel_valid  <= fsm0_valid_reg;
						--data_valid  <= '1';

					elsif (index = 1) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm1_data_reg;
						pixel_x  	 <= fsm1_x_reg;
						pixel_y  	 <= fsm1_y_reg;
						pixel_z  	 <= fsm1_z_reg;
						--data_valid  <= '1';
						--pixel_valid  <= fsm1_valid_reg;
					elsif (index = 2) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm2_data_reg;
						pixel_x  	 <= fsm2_x_reg;
						pixel_y  	 <= fsm2_y_reg;
						pixel_z  	 <= fsm2_z_reg;
						--data_valid  <= '1';
						--pixel_valid  <= fsm2_valid_reg;
					elsif (index = 3) then
						--stop_IDP  <= '1';
						pixel_value  <= fsm3_data_reg;
						pixel_x  	 <= fsm3_x_reg;
						pixel_y  	 <= fsm3_y_reg;
						pixel_z  	 <= fsm3_z_reg;
						--data_valid  <= '1';
						--pixel_valid  <= fsm3_valid_reg;
					elsif (index = 4) then
						--stop_IDP  <= '0';
						--data_valid  <= '0';
					end if;	

				end if;
				end if;

				end if;
				--end if;

		end process data_select_process;


	end bhv;
