LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
use work.func_external.all;

entity locator is 
	port( 
		fsm0_data  : in integer;
		fsm1_data  : in integer;
		fsm2_data  : in integer;
		fsm3_data  : in integer;
		fsm0_valid : in integer;
		fsm1_valid : in integer;
		fsm2_valid : in integer;
		fsm3_valid : in integer;
		fsm0_x 		: in integer;
		fsm0_y 		: in integer;
		fsm0_z 		: in integer;
		fsm1_x 		: in integer;
		fsm1_y 		: in integer;
		fsm1_z 		: in integer;
		fsm2_x 		: in integer;
		fsm2_y 		: in integer;
		fsm2_z 		: in integer;
		fsm3_x 		: in integer;
		fsm3_y 		: in integer;
		fsm3_z 		: in integer;
		loc_compute_done : in integer;
		locator_clk  : in std_logic;
		locator_en   : in std_logic;
		locator_rst  : in std_logic;

		pixel_value : out integer;
		data_valid : out integer;
		stop_IDP : out integer;
		pixel_x : out integer;
		pixel_y : out integer;
		pixel_z : out integer
	 );
end locator;

architecture bhv of locator is

signal control_signal : integer;
signal pixel_valid : integer;

begin


select_signal_process :process (locator_clk,locator_rst )
begin
	if(locator_rst = '1') then
		control_signal  <= 0;
		stop_IDP  <= 0;
	elsif( rising_edge(locator_clk) and locator_en = '1') then
		if ( loc_compute_done = 1) then 
			control_signal  <= control_signal + 1;
			if control_signal = 3 then
			control_signal <= 0;
			last_element  <= 1;
			end if;
		end if;
	end if;
end process select_signal_process;



data_select_process :process (locator_rst,locator_clk )
	begin
		if(locator_rst = '1') then
			pixel_value  <= 0;
			pixel_x  	 <= 0;
			pixel_y  	 <= 0;
			pixel_z  	 <= 0;
			pixel_valid   <= 0;

		elsif(locator_en = '1') then 
			if(control_signal = 0) then
				pixel_value  <= fsm0_data;
				pixel_x  	 <= fsm0_x;
				pixel_y  	 <= fsm0_y;
				pixel_z  	 <= fsm0_z;
				pixel_valid   <= fsm0_valid;
			elsif(control_signal = 1) then
				pixel_value  <= fsm1_data;
				pixel_x  	 <= fsm1_x;
				pixel_y  	 <= fsm1_y;
				pixel_z  	 <= fsm1_z;
				pixel_valid   <= fsm1_valid;
			elsif(control_signal = 2) then
				pixel_value  <= fsm2_data;
				pixel_x  	 <= fsm2_x;
				pixel_y  	 <= fsm2_y;
				pixel_z  	 <= fsm2_z;
				pixel_valid   <= fsm2_valid;
			end if;
		end if;
	end process data_select_process;


end bhv;
