LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
use work.func_external.all;


entity input_tracker is
	port (
		tracker_clk : in std_logic;
		bus_index_signal : in integer;
		tracker_reset : in std_logic;
		tracker_enable : in std_logic;
		input_tracker_in : in std_logic_vector (bus_width-1 downto 0);
		tracker_out_address_0 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_1 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_2 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_3 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_4 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_5 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_6 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_7 : out unsigned (SIZE_sram_address-1 downto 0);
		stripe_done : out std_logic

	);
end input_tracker;

architecture behavioral of input_tracker is


component hammingweight
	port (
		 hamming_clk   : in std_logic;
		 hammingweight_reset : in std_logic;
		 hammingweight_enable : in std_logic;

		 din   : in std_logic_vector (bus_width -1 downto 0);
		 --bus_index : out integer;
		 hammingweight_result_1 	: out integer range 0 to 16;
		 hammingweight_result_2 	: out integer range 0 to 16 
		 );
end component;

type tracker_states is (reset_state,row1,row2,row3,row4,row5,row6,row7,row0,row1new);
signal current_state, next_state : tracker_states;

signal hamming_1 : integer range 0 to 16;
signal hamming_2 : integer range 0 to 16;

signal row0address : unsigned (SIZE_sram_address -1 downto 0);
signal row1address : unsigned (SIZE_sram_address -1 downto 0);
signal row2address : unsigned (SIZE_sram_address -1 downto 0);
signal row3address : unsigned (SIZE_sram_address -1 downto 0);
signal row4address : unsigned (SIZE_sram_address -1 downto 0);
signal row5address : unsigned (SIZE_sram_address -1 downto 0);
signal row6address : unsigned (SIZE_sram_address -1 downto 0);
signal row7address : unsigned (SIZE_sram_address -1 downto 0);
signal bus_index_signal_con : integer;


begin



	tracker_out_address_0 <= row0address ; 
	tracker_out_address_1 <= row1address ; 
	tracker_out_address_2 <= row2address ; 
	tracker_out_address_3 <= row3address; 
	tracker_out_address_4 <= row4address; 
	tracker_out_address_5 <= row5address; 
	tracker_out_address_6 <= row6address; 
	tracker_out_address_7  <= row7address;

hammingweight_connecting: hammingweight port map(
		 hamming_clk                => tracker_clk,
		 hammingweight_reset        => tracker_reset,
		 hammingweight_enable       => tracker_enable,
		 din                        => input_tracker_in,
		 --bus_index => bus_index_signal,
		 hammingweight_result_1 	=> hamming_1,
		 hammingweight_result_2 	=> hamming_2
		 );


process (next_state,tracker_clk,tracker_reset,bus_index_signal_con)
	begin
		if(tracker_enable = '1') then
			if(tracker_reset = '1')then
				current_state <= reset_state;
				stripe_done  <= '0';
			elsif (rising_edge (tracker_clk)) then
				current_state <= next_state  ;
				bus_index_signal_con  <= bus_index_signal;
			end if;
		end if;
end process;





	

process(current_state,bus_index_signal_con)
variable hw_sum: integer ;
begin
	--if (tracker_enable = '1') then
	case (current_state) is

	when reset_state 	=>
			
			hw_sum := 0;
			row0address <= (others => '0');
			row1address <= (others => '0');
			row2address <= (others => '0');
			row3address <= (others => '0');
			row4address <= (others => '0');
			row5address <= (others => '0');
			row6address <= (others => '0');
			row6address <= (others => '0');
			row7address  <= (others  => '0');
			next_state <= row1;
			stripe_done  <= '0';



	when row1 	=> 		--row1 state is used to calculate the row starting address of row1, and possibly the following row starting address
						if (hamming_1 = 0) then		
						 	row1address <=  (row0address + 1 ) ;
						 	row2address <=  (row0address + 1 + to_unsigned(hamming_2,SIZE_sram_address) + 1  )  ;
						 	hw_sum := hw_sum + hamming_2;
						  	next_state  <= row3;

						elsif ( (hamming_1 /= 0)  ) then
						 	row1address <= row0address + to_unsigned(hamming_1,SIZE_sram_address) + 1;
						 	next_state  <= row2;
						 	hw_sum := hw_sum + hamming_1;

		end if;				

	when row2 => if ( row1address = (bus_index_signal_con + bus_index_signal_con)) then

						 if (hamming_1 = 0) then
							row2address <= row1address + 1;			
							row3address <= row1address + 1 + hamming_2 + 1;
					 		next_state  <= row4;
						 elsif (hamming_1 /= 0) then
						 	row2address <= row1address + hamming_1 + 1;
						 	next_state  <= row3;

						 end if;	

					 elsif ( (bus_index_signal_con + bus_index_signal_con) + 1 = row1address) then

					 		 if (hamming_2 = 0) then
					 			row2address <= row1address + 1;			
					 	 		next_state  <= row3;

					 		 elsif (hamming_2 /= 0) then
					 		 	row2address <= row1address + 1 + hamming_2;
					 		 	next_state  <= row3;

					 		 end if;	
					  end if;
										
	when row3 => if ( row2address = (bus_index_signal_con + bus_index_signal_con) )then

						 if (hamming_1 = 0) then
							row3address <= row2address + 1;			
							row4address <= row2address + 1 + hamming_2 + 1;
					 		next_state  <= row5;
						 elsif (hamming_1 /= 0) then
						 	row3address <= row2address + hamming_1 + 1;
						 	next_state  <= row4;


						 end if;	

					 elsif ( row2address = (bus_index_signal_con + bus_index_signal_con) + 1  ) then

					 		 if (hamming_2 = 0) then
					 			row3address <= row2address + 1;			
					 	 		next_state  <= row4;

					 		 elsif (hamming_2 /= 0) then
					 		 	row3address <= row2address + 1 + hamming_2 ;
					 		 	next_state  <= row4;

					 		 end if;	
					end if;					
								
								
    when row4 => if ( (bus_index_signal_con + bus_index_signal_con) = row3address) then

	 		 				 if (hamming_1 = 0) then
	 		 					row4address <= row3address + 1;			
	 		 					row5address <= row3address + 1 + hamming_2 + 1;
	 		 			 		next_state  <= row6;
	 		 				 elsif (hamming_1 /= 0) then
	 		 				 	row4address <= row3address + hamming_1 + 1;
	 		 				 	next_state  <= row5;

	 		 				 end if;	

	 		 			 elsif ( (bus_index_signal_con + bus_index_signal_con) + 1 = row3address) then

	 		 			 		 if (hamming_2 = 0) then
	 		 			 			row4address <= row3address + 1;			
	 		 			 	 		next_state  <= row5;

	 		 			 		 elsif (hamming_2 /= 0) then
	 		 			 		 	row4address <= row3address + 1 + hamming_2 ;
	 		 			 		 	next_state  <= row5;

	 		 			 		 end if;	
	 		 			 end if;

    when row5 =>	if ( (bus_index_signal_con + bus_index_signal_con) = row4address) then

 		 					 if (hamming_1 = 0) then
 		 						row5address <= row4address + 1;			
 		 						row6address <= row4address + 1 + hamming_2 + 1;
 		 				 		next_state  <= row7;
 		 					 elsif (hamming_1 /= 0) then
 		 					 	row5address <= row4address + hamming_1 + 1;
 		 					 	next_state  <= row6;



 		 					 end if;	

 		 			elsif ( (bus_index_signal_con + bus_index_signal_con) + 1 = row4address) then 
 		 				 													--means we found the SM in the high 16bit of bus
 		 				 		 	row5address <= row4address + 1 + hamming_2 ;
 		 				 		 	next_state  <= row6;
					end if;
 		 			 --end if;									 		 								
			    						 		 			
    when row6 => 	if ( (bus_index_signal_con + bus_index_signal_con) = row5address) then

							 if (hamming_1 = 0) then
								row6address <= row5address + 1;			
								row7address <= row5address + 1 + hamming_2 + 1;
						 		next_state  <= row0;
						 		--bus_index <= bus_index + 1;
							 elsif (hamming_1 /= 0) then
							 	row6address <= row5address + hamming_1 + 1;
							 	next_state  <= row7;

							 end if;

					elsif ( (bus_index_signal_con + bus_index_signal_con) + 1 = row5address) then

						 			row6address <= row5address + 1 + hamming_2;			
						 			next_state  <= row7;

					end if;						 		 			


	when row7  => 	
					stripe_done  <= '1';
					if ( (bus_index_signal_con + bus_index_signal_con) = row6address) then
							 if (hamming_1 = 0) then
								row7address <= row6address + 1; 
								row0address  <= row6address + 1 + hamming_2 + 1;
						 		next_state  <= row1;

							 elsif (hamming_1 /= 0) then
							 	row7address <= row6address + hamming_1 + 1;
							 	next_state  <= row0;

							 end if;

					elsif ( (bus_index_signal_con + bus_index_signal_con) + 1 = row6address) then

						 			row7address <= row6address + 1 + hamming_2;			
						 			next_state  <= row0;
					end if;

	when row0  =>   stripe_done  <= '0';
					if ( (bus_index_signal_con + bus_index_signal_con) = row7address) then


							 if (hamming_1 = 0) then
								row0address <= row7address + 1; 
								row1address  <= row7address + 1 + hamming_2 + 1;
						 		next_state  <= row2;

							 elsif (hamming_1 /= 0) then
							 	row0address <= row7address + hamming_1 + 1;
							 	next_state  <= row1new;

							 end if;

					elsif ( (bus_index_signal_con + bus_index_signal_con) + 1 = row7address) then

						 			row0address <= row7address + 1 + hamming_2;			
						 			next_state  <= row1new;
			
					end if;

	when row1new => if ( row0address = (bus_index_signal_con + bus_index_signal_con)) then

						 if (hamming_1 = 0) then
							row1address <= row0address + 1;			
							row2address <= row0address + 1 + hamming_2 + 1;
					 		next_state  <= row3;
						 elsif (hamming_1 /= 0) then
						 	row1address <= row0address + hamming_1 + 1;
						 	next_state  <= row2;

						 end if;	

					 elsif ( (bus_index_signal_con + bus_index_signal_con) + 1 = row0address) then

					 		 if (hamming_2 = 0) then
					 			row2address <= row1address + 1;			
					 	 		next_state  <= row2;

					 		 elsif (hamming_2 /= 0) then
					 		 	row1address <= row0address + 1 + hamming_2;
					 		 	next_state  <= row2;

					 		 end if;	
					  end if;			

			end case;


end process;
end behavioral;

