LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
use work.func_external.all;

entity fsm_reg is
	port(
		fsm_reg_clock          : in std_logic;
		fsm_reg_reset          : in std_logic;
		fsm_reg_enable         : in std_logic;
		fsm_reg_input_segment  : in std_logic_vector (SM_segment_bit-1 downto 0);
		sm_valid             : out std_logic;
		fsm_reg_output_segment : out std_logic_vector (SM_segment_bit-1 downto 0)

		); 

end entity fsm_reg;

architecture fsm_reg_archi of fsm_reg is

signal sm_reg : std_logic_vector (SM_segment_bit-1 downto 0);

begin
	
fsm_reg_output_segment  <= sm_reg;
--------------------------------------------------------------------------------
-- Register to store the sm
--------------------------------------------------------------------------------

reg : 	process (fsm_reg_clock,fsm_reg_reset)
		begin
			if (fsm_reg_reset = '1') then
				sm_reg  <= x"0000";
				sm_valid  <= '0';

			elsif(fsm_reg_enable = '1') then
				if (rising_edge(fsm_reg_clock)) then
					sm_reg  <= fsm_reg_input_segment;
					sm_valid  <= '1';
				end if;
			
			end if;
		end process;

end architecture fsm_reg_archi;