LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
use work.func_external.all;


entity controller is
	port 
	(
		controller_clk		: in std_logic;
		controller_reset	: in std_logic;
		controller_enable	: in std_logic;
		pixel_value			: in unsigned (15 downto 0);
		pixel_x				: in integer;
		pixel_y				: in integer;
		pixel_z				: in integer;
		pixel_valid 		: in integer;

		control_kernel_address 		: out integer;
		control_kernel_address_ready 		: out integer;
		control_pixel		: out unsigned (15 downto 0);
		control_x			: out integer;
		control_y			: out integer;
		control_z			: out integer

	);
	
end entity;

architecture rtl of controller is

	signal column_store : std_logic;
	signal pixel_y_compare : integer;
	signal kernel_address : integer;
	signal address_generation : integer;
	signal layer_addition : integer;
	signal yellow_index,green_index,white_index,blu_index,general_index : integer;
	signal kernel_address_ready : integer;
	signal red_00,red_063,red_630,red_6363 : integer;
begin

	control_kernel_address_ready  <= kernel_address_ready;
	control_kernel_address  <= kernel_address;
	control_x  <= pixel_x;
	control_y  <= pixel_y;
	control_z  <= pixel_z;

	column_compare : process(controller_clk)
	begin 
	if (column_store = '1') then     --this one is used to detect if there is a column shift
									 --so we can shift out one column of result
		pixel_y_compare   <= pixel_y;
	end if;
	end process;


	process (controller_clk,controller_reset)


	begin
		if (controller_reset = '1') then
			kernel_address  <= 0;
			green_index <= 0;
			white_index <= 0;
			yellow_index <= 0;
			blu_index <= 0;
			general_index <=0;
			address_generation  <= 1;
			layer_addition <= 1;
			red_00  <= 0;
			red_063  <= 0;
			red_630   <= 0;
			red_6363  <= 0;



		elsif (controller_enable = '1') then 
			if (pixel_valid = 1) then 
				if (rising_edge(controller_clk) ) then
					if ( address_generation = 1) then  		
						if (pixel_x = 0 and pixel_y = 0) then     --this pixel at top left corner (red pixel)
							red_00  <= red_00 + 1;
							kernel_address <= kernel_address + 9*pixel_z;
							address_generation <= 0;   --means the stop the generation of kernel address
							kernel_address_ready  <= 2;

						elsif (pixel_x = SIZE_input_image_vertical-1 and pixel_y = 0) then --this pixel at bottom left corner (red pixel)
							red_630  <= red_630 + 1;
							kernel_address <= kernel_address + 2 + 9*pixel_z;
							address_generation <= 0; 
							kernel_address_ready  <= 2;

						elsif (pixel_x = SIZE_input_image_vertical-1 and pixel_y = SIZE_input_image_horizontal-1) then --this pixel at bottom right corner (red pixel)
							red_6363  <= red_6363 + 1;
							kernel_address <= kernel_address + 8 + 9*pixel_z;
							address_generation <= 0; 
							kernel_address_ready  <= 2;

						elsif (pixel_x = 0 and pixel_y = SIZE_input_image_horizontal-1) then --this pixel at top right corner (red pixel)
							red_063  <= red_063 + 1;
							kernel_address <= kernel_address + 6 + 9*pixel_z;
							address_generation <= 0; 
							kernel_address_ready  <= 2;

						elsif (pixel_x = 0 and pixel_y = 1) then	--green pixel  on top edge left
							kernel_address <= kernel_address + 9*pixel_z + 3*green_index;
							green_index    <= green_index + 1;
							if (green_index = 2) then 
								address_generation <= 0;
							end if;

						elsif (pixel_x = 0 and pixel_y = 62) then	--green pixel on top edge right 
							kernel_address <= kernel_address + 9*pixel_z + 3 + 3*green_index;
							green_index    <= green_index + 1;
							if (green_index = 2) then 
								address_generation <= 0;
							end if;

						elsif (pixel_x = 1 and pixel_y = 63) then	--green pixel on right edge top
							kernel_address <= kernel_address + 9*pixel_z + 6 + green_index;
							green_index    <= green_index + 1;
							if (green_index = 2) then 
								address_generation <= 0;
							end if;

						elsif (pixel_x = 62 and pixel_y = 63) then	--green pixel on right edge botton
							kernel_address <= kernel_address + 9*pixel_z + 7 + green_index;
							green_index    <= green_index + 1;
							if (green_index = 2) then 
								address_generation <= 0;
							end if;

						elsif (pixel_x = 63 and pixel_y = 62) then	--green pixel on bottom edge right
							kernel_address <= kernel_address + 9*pixel_z + 5 + 3*green_index;
							green_index    <= green_index + 1;
							if (green_index = 2) then 
								address_generation <= 0;
							end if;

						elsif (pixel_x = 63 and pixel_y = 1) then	--green pixel on bottom edge left
							kernel_address <= kernel_address + 9*pixel_z + 2 + 3*green_index;
							green_index    <= green_index + 1;
							if (green_index = 2) then 
								address_generation <= 0;
							end if;

						elsif (pixel_x = 62 and pixel_y = 0) then	--green pixel on left edge bottom
							kernel_address <= kernel_address + 9*pixel_z + 1 + green_index;
							green_index    <= green_index + 1;
							if (green_index = 2) then 
								address_generation <= 0;
							end if;

						elsif (pixel_x = 1 and pixel_y = 0) then	--green pixel on left edge top
							kernel_address <= kernel_address + 9*pixel_z + green_index;
							green_index    <= green_index + 1;
							if (green_index = 2) then 
								address_generation <= 0;
							end if;

						elsif (pixel_x = 0 and pixel_y > 1 and pixel_y < 62) then   --white pixel on top edge
							kernel_address <= kernel_address + 9*pixel_z + 3*white_index;
							white_index    <= white_index + 1;
							if (white_index = 3) then 
								address_generation <= 0;
							end if;

						elsif (pixel_y = 63 and pixel_x > 1 and pixel_x < 62) then   --white pixel on right edge
							kernel_address <= kernel_address + 9*pixel_z + 6 + white_index;
							white_index    <= white_index + 1;
							if (white_index = 3) then 
								address_generation <= 0;
							end if;

						elsif (pixel_x = 63 and pixel_y > 1 and pixel_y < 62) then   --white pixel on bottom edge
							kernel_address <= kernel_address + 9*pixel_z + 2 + 3*white_index;
							white_index    <= white_index + 1;
							if (white_index = 3) then 
								address_generation <= 0;
							end if;

						elsif (pixel_y = 0 and pixel_x > 1 and pixel_x < 62) then   --white pixel on left edge
							kernel_address <= kernel_address + 9*pixel_z + white_index;
							white_index    <= white_index + 1;
							if (white_index = 3) then 
								address_generation <= 0;
							end if;


						elsif (pixel_x = 1 and pixel_y = 1 ) then 	--yellow pixel on secondary top left corner
							if (layer_addition = 1) then 
								kernel_address  <= kernel_address + 9*pixel_z;
								layer_addition <= 0;
								yellow_index  <= 1;
								kernel_address_ready  <= 1;
							elsif (layer_addition = 0 and yellow_index = 1) then
								kernel_address  <= kernel_address + 1;
								yellow_index  <= yellow_index + 1;
							elsif (layer_addition = 0 and yellow_index = 2) then
								kernel_address  <= kernel_address + 2;
								yellow_index  <= yellow_index + 1;
							elsif (layer_addition = 0 and yellow_index = 3) then
								kernel_address  <= kernel_address + 1;
								address_generation  <= 0;
								--kernel_address_ready  <= 0;
							end if;

				

						elsif (pixel_x = 1 and pixel_y = 62 ) then --yellow pixel on secondary top right corner

							if (layer_addition = 1) then 
								kernel_address  <= kernel_address + 9*pixel_z + 3 ;
								layer_addition <= 0;
								yellow_index  <= 1;
								kernel_address_ready  <= 1;


							elsif (layer_addition = 0 and yellow_index = 1) then
								kernel_address  <= kernel_address + 1;
								yellow_index  <= yellow_index + 1;
							elsif (layer_addition = 0 and yellow_index = 2) then
								kernel_address  <= kernel_address + 2;
								yellow_index  <= yellow_index + 1;
							elsif (layer_addition = 0 and yellow_index = 3) then
								kernel_address  <= kernel_address + 1;
								address_generation  <= 0;
							end if;	

						elsif (pixel_x = 62 and pixel_y = 62 ) then --yellow pixel on secondary bottom right corner
							if (layer_addition = 1) then 
								kernel_address  <= kernel_address + 9*pixel_z + 4 ;
								layer_addition <= 0;
								yellow_index  <= 1;
								kernel_address_ready  <= 1;


							elsif (layer_addition = 0 and yellow_index = 1) then
								kernel_address  <= kernel_address + 1;
								yellow_index  <= yellow_index + 1;
							elsif (layer_addition = 0 and yellow_index = 2) then
								kernel_address  <= kernel_address + 2;
								yellow_index  <= yellow_index + 1;
							elsif (layer_addition = 0 and yellow_index = 3) then
								kernel_address  <= kernel_address + 1;
								address_generation  <= 0;
							end if;		


						elsif (pixel_x = 62 and pixel_y = 1 ) then --yellow pixel on secondary bottom left corner
							if (layer_addition = 1) then 
								kernel_address  <= kernel_address + 9*pixel_z + 1 ;
								layer_addition <= 0;
								yellow_index  <= 1;
								kernel_address_ready  <= 1;


							elsif (layer_addition = 0 and yellow_index = 1) then
								kernel_address  <= kernel_address + 1;
								yellow_index  <= yellow_index + 1;
							elsif (layer_addition = 0 and yellow_index = 2) then
								kernel_address  <= kernel_address + 2;
								yellow_index  <= yellow_index + 1;
							elsif (layer_addition = 0 and yellow_index = 3) then
								kernel_address  <= kernel_address + 1;
								address_generation  <= 0;
							end if;		
						


						elsif (pixel_x =1 and pixel_y >1 and pixel_y <62) then
							kernel_address  <= kernel_address + 9*pixel_z  + blu_index;  --blu pixel on secondary top edge
							blu_index <= blu_index +1;
							if (blu_index = 2) then
								blu_index <= 3;
							elsif (blu_index = 5) then
								blu_index <= 6;
							elsif (blu_index = 8) then
								address_generation  <= 0;
							end if;


						elsif (pixel_y = 62 and pixel_x >1 and pixel_x < 62) then
							kernel_address  <= kernel_address + 9*pixel_z  + 3 + blu_index;  --blu pixel on secondary right edge
							blu_index <= blu_index +1;
							if (blu_index = 7) then
								address_generation  <= 0;
							end if;


						elsif (pixel_x = 62 and pixel_y >1 and pixel_y < 62) then
							kernel_address  <= kernel_address + 9*pixel_z  + 1 + blu_index;  --blu pixel on secondary bottom edge
							blu_index <= blu_index +1;
							if (blu_index = 2) then
								blu_index <= 3;
							elsif (blu_index = 5) then
								blu_index <= 6;
							elsif (blu_index = 8) then
								address_generation  <= 0;
							end if;


						elsif (pixel_y = 1 and pixel_x >1 and pixel_x < 62) then
							kernel_address  <= kernel_address + 9*pixel_z  + blu_index;  --blu pixel on secondary left edge
							blu_index <= blu_index +1;
							if (blu_index = 7) then
								address_generation  <= 0;
							end if;


						else 															
							kernel_address  <= kernel_address + 9*pixel_z + general_index;	--all rest cases, one pixel needs all kernel matrix
							general_index <= general_index +1;
							if (general_index = 9) then
								address_generation  <= 0;
							end if;

						end if;
					else 
						address_generation  <= 1;
						white_index  <= 0;
						green_index  <= 0;
						blu_index   <= 0;
						yellow_index  <= 0;
						kernel_address  <= 0;
						layer_addition  <= 1;
						end if;
					
					end if;
				end if;
			end if;
		




	end process;
	
	

--process(controller_clk)
--begin
-- if()


end rtl;
