LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;

 -------------------------------------------------------------------------------
 -- Function:
 -- 1. SRAM, storing all the data come from input_bus
 -- 2. one read port, one write port
 -- 3. The data is written and read both at the rising edge of the clock

 -- Notes:
 -- 1. The size is set at a large number, but still needs to be corrected
 -- 2. This file has an individual testbench
 -- 3. Last test on 11 Feb 2022.
 -------------------------------------------------------------------------------
 
entity SRAM_tracker is
                          
    Port ( 

        tracker_sram_clk                       : in  STD_LOGIC;
        tracker_sram_reset                     : in  STD_LOGIC;
        start_add0                 : in  unsigned (SIZE_sram_address - 1 downto 0);
        start_add1                 : in  unsigned (SIZE_sram_address - 1 downto 0);
        start_add2                 : in  unsigned (SIZE_sram_address - 1 downto 0);
        start_add3                 : in  unsigned (SIZE_sram_address - 1 downto 0);
        start_add4                 : in  unsigned (SIZE_sram_address - 1 downto 0);
        start_add5                 : in  unsigned (SIZE_sram_address - 1 downto 0);
        start_add6                 : in  unsigned (SIZE_sram_address - 1 downto 0);
        start_add7                 : in  unsigned (SIZE_sram_address - 1 downto 0);
        tracker_sram_write_en             : in  integer;
        tracker_sram_read_en              : in  STD_LOGIC;
        tracker_sram_enable               : in  STD_LOGIC;
        fsm_stripe_done             : in STD_LOGIC;
        tracker_sram_read_address   : in integer;

        start_add_out0            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
        start_add_out1            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
        start_add_out2            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
        start_add_out3            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
        start_add_out4            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
        start_add_out5            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
        start_add_out6            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
        start_add_out7            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0)
    );
end SRAM_tracker;
 
architecture Behavioral of SRAM_tracker is

    --type Memory_Array is array (0 to (2 ** SIZE_sram_address) - 1) of STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
    type Memory_Array is array (0 to 256 ) of STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);  --for test, since the big array slows down the simulation

    signal Memory : Memory_Array;
begin
 
    -- Read process
    process (tracker_sram_clk)
    begin
        if (tracker_sram_reset = '0') then 
            if rising_edge(tracker_sram_clk) then        
                if tracker_sram_enable = '1' then
                    if ( (tracker_sram_read_en = '1')) then -- Read Memory
                        if (fsm_stripe_done  <= '1') then
                            if ( tracker_sram_read_address >= 0 ) then
                        start_add_out0 <= Memory((tracker_sram_read_address));              
                        start_add_out1 <= Memory((tracker_sram_read_address)+1);
                        start_add_out2 <= Memory((tracker_sram_read_address)+2);
                        start_add_out3 <= Memory((tracker_sram_read_address)+3);
                        start_add_out4 <= Memory((tracker_sram_read_address)+4);
                        start_add_out5 <= Memory((tracker_sram_read_address)+5);
                        start_add_out6 <= Memory((tracker_sram_read_address)+6);
                        start_add_out7 <= Memory((tracker_sram_read_address)+7);
                            end if;
                        end if;
                    end if;
                end if;      
            end if;
        end if;
    end process;
 
    -- Write process
    process (tracker_sram_clk)
    variable sram_write_address : integer range 0 to 255;   
                                                              
  
    begin
            if tracker_sram_reset = '1' then
                -- Clear Memory on sram_reset
                Memory <= (others => (others => '0'));
                sram_write_address := 0;   --value needs to be changed if change the number of sram banks
                                               -- if bank number = 4; we use 0 to 65535
                                               -- if bank number = 8; we use 0 to 65535*2
            elsif ((tracker_sram_enable = '1') ) then
                if ((tracker_sram_write_en = 1) ) then
                    if falling_edge(tracker_sram_clk) then
                        if ( (sram_write_address + SIZE_kernel_number + 1) < 255) then  --check if memory will be full
                  
                    -- Store start_add to Current Memory Address
                    Memory(sram_write_address) <= std_logic_vector(start_add0);
                    Memory(sram_write_address+1) <= std_logic_vector(start_add1);
                    Memory(sram_write_address+2) <= std_logic_vector(start_add2);
                    Memory(sram_write_address+3) <= std_logic_vector(start_add3);
                    Memory(sram_write_address+4) <= std_logic_vector(start_add4);
                    Memory(sram_write_address+5) <= std_logic_vector(start_add5);
                    Memory(sram_write_address+6) <= std_logic_vector(start_add6);
                    Memory(sram_write_address+7) <= std_logic_vector(start_add7);

                    sram_write_address := sram_write_address + SIZE_kernel_number + 1;

                    else 
                        sram_write_address := 0;    --in case memory full, circular to the beginning
                    end if;
                end if;
            end if;
        end if; 
        
    end process;
end Behavioral;