LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;

 -------------------------------------------------------------------------------
 -- Function:
 -- 1. SRAM, storing all the data come from input_bus
 -- 2. one read port, one write port
 -- 3. The data is written and read both at the rising edge of the clock

 -- Notes:
 -- 1. The size is set at a large number, but still needs to be corrected
 -- 2. This file has an individual testbench
 -- 3. Last test on 11 Feb 2022.
 -------------------------------------------------------------------------------
 
entity SRAM is
                          
    Port ( 

        sram_clk                       : in  STD_LOGIC;
        sram_reset                     : in  STD_LOGIC;
        dram_data_valid         : in std_logic;
        dram_data                 : in  STD_LOGIC_VECTOR (bus_width - 1 downto 0);
        sram_read_address0         : in  STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
        sram_read_address1         : in  STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
        sram_read_address2         : in  STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
        sram_read_address3         : in  STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
        sram_read_address4         : in  STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
        sram_read_address5         : in  STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
        sram_read_address6        : in  STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
        sram_read_address7         : in  STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
        sram_write_en             : in  STD_LOGIC;
        sram_read_en              : in  STD_LOGIC;
        sram_enable               : in  STD_LOGIC;
        
        sram_full            : out  std_logic;
        sram_data0            : out STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
        sram_data1            : out STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
        sram_data2            : out STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
        sram_data3            : out STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
        sram_data4            : out STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
        sram_data5            : out STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
        sram_data6            : out STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
        sram_data7           : out STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
        sram_read_data_valid : out std_logic
    );
end SRAM;
 
architecture Behavioral of SRAM is

    --type Memory_Array is array (0 to (2 ** SIZE_sram_address) - 1) of STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
    type Memory_Array is array (0 to 300 ) of STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);  --for test, since the big array slows down the simulation

    signal Memory : Memory_Array;

begin
 
    -- Read process
    process (sram_clk)
    begin
        if rising_edge(sram_clk) then        
            if sram_enable = '1' then
                if ( (sram_read_en = '1')) then
                    -- Read Memory
                    sram_data0 <= Memory(to_integer(unsigned(sram_read_address0)));
                    sram_data1 <= Memory(to_integer(unsigned(sram_read_address1)));
                    sram_data2 <= Memory(to_integer(unsigned(sram_read_address2)));
                    sram_data3 <= Memory(to_integer(unsigned(sram_read_address3)));
                    sram_data4 <= Memory(to_integer(unsigned(sram_read_address4)));
                    sram_data5 <= Memory(to_integer(unsigned(sram_read_address5)));
                    sram_data6 <= Memory(to_integer(unsigned(sram_read_address6)));
                    sram_data7 <= Memory(to_integer(unsigned(sram_read_address7)));
                    sram_read_data_valid  <= '1';
                else 
                    sram_read_data_valid  <= '0';
                end if;
            end if;      
        end if;
    end process;
 
    -- Write process
    process (sram_clk)
    variable sram_write_address : integer range 0 to 300;   
  -- --  integer range needs to be changed if change the number of sram banks   
                                                              
  -- --  1st, this value should be set a little bit larger otherwise it will stop the simulation
                                                              
  -- --  2nd, if bank number = 4; the available address is 0 to 65535, so here the range should be at least 65536, but 70000 better
                                                              
  -- --  3rd, if bank number = 8; the available address is 0 to 65535*2, so here better should be 140000;
  
    begin
        if rising_edge(sram_clk) then
            if sram_reset = '1' then
                -- Clear Memory on sram_reset
                Memory <= (others => (others => '0'));
                sram_full <= '0';
                sram_write_address := 0;   --value needs to be changed if change the number of sram banks
                                               -- if bank number = 4; we use 0 to 65535
                                               -- if bank number = 8; we use 0 to 65535*2
            elsif ((sram_enable = '1') and (sram_write_address < 300)) then
                if ((sram_write_en = '1') ) then
                    if (dram_data_valid = '1') then
                    -- Store dram_data to Current Memory Address
                    Memory(sram_write_address) <= dram_data(15 downto 0);
                    sram_write_address := sram_write_address + 1;
                    Memory(sram_write_address) <= dram_data(31 downto 16);
                    sram_write_address := sram_write_address + 1;
                    end if;
                end if;
            end if;
        end if; 
        
        if (sram_write_address = 300) then
            sram_full <='1';      
        end if;
    end process;
end Behavioral;