LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
use work.func_external.all;



entity IDP_manager is
	generic (
			 SIZE_sram_address : integer
			 SM_segment_bit : integer
			 pixel_memory_bank_number : integer
			 SIZE_input_image_horizontal_coordinate : integer
			 );
	port (
		clock 				 : in  std_logic;
		row_starting_address : in  std_logic_vector (SIZE_sram_address-1 downto 0 );
		sm    			     : in  std_logic_vector (SM_segment_bit-1 downto 0);
		reset  				 : in  std_logic;
		
		address  		 : out std_logic_vector (SIZE_sram_address-1 downto 0 );
		read_array		 : out std_logic_vector (pixel_memory_bank_number-1 downto 0);
		write_array		 : out std_logic_vector (pixel_memory_bank_number-1 downto 0);
		spatial_coord    : out std_logic_vector (SIZE_input_image_horizontal_coordinate-1 downto 0)
		);
end IDP_manager;

architecture behavioral of IDP_manager is
	signal write_array : std_logic_vector (pixel_memory_bank_number-1 downto 0) := (others => 0);
	signal read_array : std_logic_vector (pixel_memory_bank_number-1 downto 0) := (others => 0);
begin
	arbitration : 	for i in 0 to pixel_memory_bank_number-1 generate

						write_array(0) = 1;

						if ( sram_full(i) = 1 )  then
							
							write_array(i) = 0;
							write_array(i+1) = 1;
							read_array(i) = 1;
     					
     					end if;


					end generate; 				
end behavioral;