LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
use work.func_external.all;


--------------------------------------------------------------------------------
-- 
--------------------------------------------------------------------------------


entity FSM is
	port (
		fsm_clock                   : in std_logic;
		fsm_reset                   : in std_logic;
		fsm_enable					: in std_logic;
		memory_address              : in std_logic_vector (SIZE_sram_address-1 downto 0);
		tracker_address             : in std_logic_vector (SIZE_sram_address-1 downto 0);
		memory_segment              : in std_logic_vector (SM_segment_bit-1 downto 0);
		tracker_ready 				: in std_logic;
		--sm_value					: in std_logic_vector (SM_segment_bit-1 downto 0);
		sm_or_not					: out std_logic;
		--sm_out 						: out std_logic_vector(SM_segment_bit-1 downto 0);
		fsm_output_address          : out std_logic_vector (SIZE_sram_address -1 downto 0);
		fsm_sram_control		    : out std_logic;
		fsm_stripe_done				: out std_logic;
		fsm_tracker_address			: out integer
	);
end FSM;

architecture FSM_arc of FSM is

	type type_state is (reset,value_true,value_false,new_start,update);
	signal current_state,next_state : type_state;
	signal current_segment_value : std_logic;
	signal index : integer range -2 to 16;
	signal segment_full : std_logic;
	----------------------------------------------------------------------------
	-- sm_value is used as a register to store the sparsity map
	-- So the register isn't built independently, it's merged in the file "FSM.vhd"
	----------------------------------------------------------------------------
	
	signal sm_value : std_logic_vector (SM_segment_bit-1 downto 0);
	signal fsm_reg_address : std_logic_vector (SIZE_sram_address-1 downto 0);
	signal fsm_tracker_address_buffer : integer;



begin

	fsm_sram_control  <= fsm_enable;
	fsm_tracker_address  <= fsm_tracker_address_buffer;
-----------------------------------------------------------------------------
--  next state
-----------------------------------------------------------------------------	

	next_state_proc: process(fsm_clock,fsm_reset)
	begin
			if (fsm_reset = '1') then
				current_state  <= reset;
				index  <= -2;


			elsif (rising_edge(fsm_clock)) then
				if (fsm_enable = '1') then
					if (tracker_ready = '1') then
						current_state  <= next_state;
						
							if( index  <= 15) then 
								index  <= index + 1;
							else 
								index  <= 0;
							end if;
					end	 if;
				else 
					current_state  <= reset;
				end if;
			end if;
	end process next_state_proc;

--------------------------------------------------------------------------------
-- future state network
--------------------------------------------------------------------------------

	future_state_proc: process(current_state,index,memory_segment)
	begin
		
		case current_state is

			when reset => 
				if (fsm_enable = '1') then
					next_state  <= new_start;
				else
					next_state  <= reset;
				end if;
			
			when new_start => 
				if (fsm_enable = '1') then
					if (memory_segment(0) = '1') then
						next_state  <= value_true;
					elsif (memory_segment(0) = '0') then
						next_state  <= value_false;
					end if;
				else
					next_state  <= reset;
				end if;

			when value_true => 
				if(fsm_enable = '1') then
					if ( index < 16 ) then
						if (sm_value(index) = '1') then
							next_state  <= value_true;
						elsif (sm_value(index) = '0') then
							next_state  <= value_false;
						end if;
					else
						next_state  <= update;
					end if;
 				else 
 					next_state  <= reset;
 				end if;

 			when value_false =>

				if(fsm_enable = '1') then
					if ( index < 16 ) then
						if (sm_value(index) = '1') then
							next_state  <= value_true;
						elsif (sm_value(index) = '0') then
							next_state  <= value_false;
						end if;
					else 
						next_state  <=  update;
					end if;
				else 
					next_state  <= reset;
				end if;

			when update  => 
				if (fsm_enable = '1') then
					if (tracker_ready = '1') then 
						next_state  <= new_start;
					else 
						next_state   <= update;

					end if;
				else
					next_state  <= reset;
				end if;



		end case;
	end process future_state_proc;


--------------------------------------------------------------------------------
-- output network
--------------------------------------------------------------------------------

fsm_output_address  <= fsm_reg_address;

	output_network: process(current_state,index)
	begin
			case current_state is

				when reset => 
						fsm_tracker_address_buffer  <= 0;
						fsm_stripe_done  <= '1';


				when new_start => 
					sm_or_not  <= '1';  -- 1 means it's sm
					sm_value  <= memory_segment;
					fsm_reg_address  <=  std_logic_vector(unsigned(tracker_address));						
					fsm_stripe_done  <= '0';

				when value_true => 
					if ( index < 15 and index > 0 ) then
						current_segment_value  <= sm_value(index-1);
						sm_or_not  <= '0';  -- 0 means it's not sm, maybe invalid data, maybe pixel
						fsm_reg_address  <=  std_logic_vector(unsigned(fsm_reg_address) + 1);
					elsif ( index = 0 ) then  						
						sm_or_not  <= '1';  -- 1 means it's sm

					end if;

				when value_false => 
					if ( index < 15 and index > 0 ) then
						current_segment_value  <= sm_value(index-1);
						sm_or_not  <= '0';  -- 0 means it's pixel

					elsif ( index = 0 ) then  						
						sm_or_not  <= '1';

					end if;

				when update  => 
						--fsm_reg_address  <= tracker_address;
						fsm_tracker_address_buffer  <= fsm_tracker_address_buffer + SIZE_kernel_number + 1;
						fsm_stripe_done  <= '1';

				end case;

	end process output_network;



end FSM_arc;