LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;

entity tb_sram_single is
end tb_sram_single;

--------------------------------------------------------------------------------
-- Funtion:
--	1.testbench for a single sram, without any other units connected.

-- Notes:
-- 1. Last test on 11 Feb 2022.
--------------------------------------------------------------------------------



architecture tb_beha of tb_sram_single is


	component SRAM is
        Port ( 
        sram_clk                       : in  STD_LOGIC;
        sram_reset                     : in  STD_LOGIC;
        dram_data_valid 		: in std_logic;
        dram_data                 : in  STD_LOGIC_VECTOR (bus_width - 1 downto 0);
        sram_read_address         : in  STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
        sram_write_en             : in  STD_LOGIC;
        sram_read_en              : in  STD_LOGIC;
        sram_enable               : in  STD_LOGIC;
        sram_full            : out  std_logic;
        sram_data            : out STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
        row_starting_address : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
        sram_read_data_valid : out std_logic

    );
	end component;

signal sram_reset : std_logic;
signal sram_clk : std_logic;
signal test_dram_data : std_logic_vector (bus_width-1 downto 0);
signal test_sram_read_address : std_logic_vector (SIZE_sram_address-1 downto 0);
signal test_write_en : std_logic;
signal test_read_en : std_logic;
signal test_enable : std_logic;
signal test_full : std_logic;
signal test_outputdata : std_logic_vector (memory_cell_width-1 downto 0);
signal row_starting_address : std_logic_vector (SIZE_sram_address-1 downto 0);
signal dram_data_valid : std_logic;
signal sram_read_data_valid : std_logic;
constant tb_sram_clk : time := 10 ns;


begin

	DUT: SRAM port map (  
		sram_clk    =>  sram_clk,              
		sram_reset  =>  sram_reset,             
		dram_data_valid  =>  dram_data_valid,
		dram_data   => test_dram_data,        
		sram_read_address   => test_sram_read_address,
		sram_write_en       => test_write_en,
		sram_read_en        => test_read_en,
		sram_enable         => test_enable,
		sram_full           => test_full,
		sram_data           => test_outputdata,
		row_starting_address => row_starting_address,
		sram_read_data_valid  => sram_read_data_valid

		);

	sram_CLK_process : process

	begin
	  sram_clk <= '0';
	  wait for tb_sram_clk;
	  sram_clk <= '1';
	  wait for tb_sram_clk;	 
	end process;


     process
     begin
     	
--------------------------------------------------------------------------------
--  testing block for writing into sram begins                                      --
--------------------------------------------------------------------------------
     	sram_reset <= '1';
     	test_dram_data <= x"00010001";    
    	test_write_en <= '1';
    	test_read_en <= '0';
    	test_enable <= '0';
    	dram_data_valid  <= '0';
    	--test_sram_read_address <= x"FFF0";
    	wait for 20ns;


    	sram_reset <= '0';
    	dram_data_valid  <= '0';
    	test_dram_data <= x"00010001";
    	test_write_en <= '1';
    	test_read_en <= '0';
    	test_enable <= '0';
    	--test_sram_read_address <= x"FFF0";
    	wait for 20ns;


    	sram_reset <= '0';
    	dram_data_valid  <= '1';
    	test_dram_data <= x"00010001";
    	test_write_en <= '1';
    	test_read_en <= '0';
    	test_enable <= '0';
    	--test_sram_read_address <= x"FFF0";
    	wait for 20ns;

    	sram_reset <= '0';
    	dram_data_valid  <= '0';
    	test_dram_data <= x"00010001";
    	test_write_en <= '1';
    	test_read_en <= '0';
    	test_enable <= '1';
    	--test_sram_read_address <= x"FFF0";
    	wait for 20ns;

    	sram_reset <= '0';
    	dram_data_valid  <= '0';
    	test_dram_data <= x"00010001";
    	test_write_en <= '1';
    	test_read_en <= '0';
    	test_enable <= '1';
    	--test_sram_read_address <= x"FFF0";
    	wait for 20ns;

    	sram_reset <= '0';
    	dram_data_valid  <= '1';
    	test_dram_data <= x"00010001";
    	test_write_en <= '1';
    	test_read_en <= '0';
    	test_enable <= '1';
    	--test_sram_read_address <= x"FFF0";
    	wait for 20ns;

    	sram_reset <= '0';
    	test_dram_data <= x"00010001";
    	test_write_en <= '1';
    	test_read_en <= '0';
    	test_enable <= '1';
    	--test_sram_read_address <= x"FFF0";
    	wait for 20ns;


    	sram_reset <= '0';
    	test_dram_data <= x"00010010";    	
    	test_write_en <= '1';
    	test_read_en <= '0';
    	test_enable <= '1';
    	--test_sram_read_address <= x"FFF1";
    	wait for 20ns;


    	sram_reset <= '0';
    	test_dram_data <= x"00010011";    	
    	test_write_en <= '1';
    	test_read_en <= '0';
    	test_enable <= '1';
    	--test_sram_read_address <= x"FFF2";
    	wait for 20ns;


    	sram_reset <= '0';
    	test_dram_data <= x"00010100";    	
    	test_write_en <= '1';
    	test_read_en <= '0';
    	test_enable <= '1';
    	--test_sram_read_address <= x"FFF3";
    	wait for 20ns;


    	sram_reset <= '0';
    	test_dram_data <= x"00010101";    	
    	test_write_en <= '1';
    	test_read_en <= '0';
    	test_enable <= '1';
    	--test_sram_read_address <= x"FFF4";
    	wait for 20ns;


    	sram_reset <= '0';
    	test_dram_data <= x"00010110";    	
    	test_write_en <= '1';
    	test_read_en <= '0';
    	test_enable <= '1';
    	--test_sram_read_address <= x"FFF5";
    	wait for 20ns;


--------------------------------------------------------------------------------
--  testing block for writing to sram ends                          --
--------------------------------------------------------------------------------



--------------------------------------------------------------------------------
--       testing block for reading from sram begins                         --
--------------------------------------------------------------------------------
			wait for 10 ns;
    	 	sram_reset <= '0';
    	 	--test_dram_data <= x"00010001";    
    		test_write_en <= '0';
    		test_read_en <= '1';
    		test_enable <= '1';
    		test_sram_read_address <= x"0000";
    		wait for 20ns;


    		sram_reset <= '0';
    		--test_dram_data <= x"00010001";
    		test_write_en <= '0';
    		test_read_en <= '1';
    		test_enable <= '0';
    		test_sram_read_address <= x"0001";
    		wait for 20ns;


    		sram_reset <= '0';
    		--test_dram_data <= x"00010001";
    		test_write_en <= '0';
    		test_read_en <= '1';
    		test_enable <= '1';
    		test_sram_read_address <= x"0002";
    		wait for 20ns;


    		sram_reset <= '0';
    		--test_dram_data <= x"00010010";    	
    		test_write_en <= '0';
    		test_read_en <= '1';
    		test_enable <= '1';
    		test_sram_read_address <= x"0003";
    		wait for 20ns;


    		sram_reset <= '0';
    		--test_dram_data <= x"00010011";    	
    		test_write_en <= '0';
    		test_read_en <= '1';
    		test_enable <= '1';
    		test_sram_read_address <= x"0004";
    		wait for 20ns;


    		sram_reset <= '0';
    		--test_dram_data <= x"00010100";    	
    		test_write_en <= '0';
    		test_read_en <= '1';
    		test_enable <= '1';
    		test_sram_read_address <= x"0005";
    		wait for 20ns;


    		sram_reset <= '0';
    		--test_dram_data <= x"00010101";    	
    		test_write_en <= '0';
    		test_read_en <= '1';
    		test_enable <= '1';
    		test_sram_read_address <= x"0006";
    		wait for 20ns;


    		sram_reset <= '0';
    		--test_dram_data <= x"00010110";    	
    		test_write_en <= '0';
    		test_read_en <= '1';
    		test_enable <= '1';
    		test_sram_read_address <= x"0007";
    		wait for 20ns;
    	wait;


--------------------------------------------------------------------------------
--    testing block for reading from sram ends                               --
--------------------------------------------------------------------------------


end process;

end tb_beha;