LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
use work.func_external.all;

--------------------------------------------------------------------------------
-- Function
-- 1.test the functionality of sram_kernel
-- 2.sram_kernel reads the data from "data.txt" at every falling edge of the clock
-- 3.sram_kernel will write data to memory, and the memory accept the data at every rising edge of the clock
--------------------------------------------------------------------------------


entity tb_sram_kernel is
end tb_sram_kernel;



architecture tb_kernel_arc of tb_sram_kernel is

	component sram_kernel is
		  port(  
             kernel_clk : IN std_logic;
             kernel_reset : in std_logic;
             kernel_enable : in std_logic;
             kernel_address : in integer;

             kernel_data_valid : out std_logic;   
             kernel_data : OUT signed (SM_segment_bit-1 downto 0) 
     );
	end component;

	signal kernel_data : signed (SM_segment_bit-1 downto 0);
	signal kernel_clk   : std_logic;
	signal kernel_reset   : std_logic;
	signal kernel_enable : std_logic;
  signal kernel_data_valid : std_logic;
  signal kernel_address : integer;
	constant tb_clk : time := 10 ns;

begin

	DUT: sram_kernel port map (    
      kernel_clk => kernel_clk, 
			kernel_reset => kernel_reset, 
      kernel_enable  => kernel_enable,   
      kernel_address  => kernel_address,
      
      kernel_data_valid  => kernel_data_valid,
			kernel_data => kernel_data 
      );

  CLK_process : process

    begin

      kernel_clk <= '0';

      wait for tb_clk;

      kernel_clk <= '1';

      wait for tb_clk;
 
     end process;

    process
    begin

     kernel_enable  <= '0', '1' after 39 ns;
     kernel_reset   <= '1', '0' after 29 ns;

     wait;

     end process;

    process (kernel_clk)
    begin
     if kernel_reset = '1' then
      kernel_address  <= 0;
     elsif rising_edge(kernel_clk) then
      kernel_address  <= kernel_address + 1;
     end if;
    end process;

end tb_kernel_arc;

