LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
use work.func_external.all;
use std.textio.all;

--------------------------------------------------------------------------------
-- Function
-- 1.To connect input_bus and SRAM, test its functionality
--------------------------------------------------------------------------------


entity tb_pre_buffer_fsm is
end tb_pre_buffer_fsm;

architecture tb_pre_buffer_fsm_arc of tb_pre_buffer_fsm is

component pre_buffer_fsm is
    port(    
    	pre_buffer_fsm_clock         : in std_logic;
    	pre_buffer_fsm_reset         : in std_logic;
    	pre_buffer_fsm_enable		: in std_logic;
    	max_pooling_enable			: in std_logic;
    	relu_enable					: in std_logic;
    	ccm_din_shift				: in std_logic;
    	ccm_din_data_valid			: in std_logic;		--shift signal sent from mac_ccm
    	ccm_din1_1					: in integer;
    	ccm_din1_2					: in integer;
    	ccm_din2_1					: in integer;
    	ccm_din2_2					: in integer;
    	ccm_din3_1					: in integer;
    	ccm_din3_2					: in integer;
    	ccm_din4_1					: in integer;
    	ccm_din4_2					: in integer;
    	ccm_din5_1					: in integer;
    	ccm_din5_2					: in integer;
    	ccm_din6_1					: in integer;
    	ccm_din6_2					: in integer;
    	ccm_din7_1					: in integer;
    	ccm_din7_2					: in integer;
    	ccm_din8_1					: in integer;
    	ccm_din8_2					: in integer;
    	ccm_din9_1					: in integer;
    	ccm_din9_2					: in integer;
    	ccm_din10_1					: in integer;
    	ccm_din10_2					: in integer;
    	ccm_din11_1					: in integer;
    	ccm_din11_2					: in integer;
    	ccm_din12_1					: in integer;
    	ccm_din12_2					: in integer;
    	ccm_din13_1					: in integer;
    	ccm_din13_2					: in integer;
    	ccm_din14_1					: in integer;
    	ccm_din14_2					: in integer;
    	ccm_din15_1					: in integer;
    	ccm_din15_2					: in integer;
    	ccm_din16_1					: in integer;
    	ccm_din16_2					: in integer
     );
end component;

--------------------------------------------------------------------------------
signal clk,reset,enable,max_pooling_enable,relu_enable,ccm_din_shift,ccm_din_data_valid : std_logic;
--------------------------------------------------------------------------------
signal ccm_din1_1 : integer;		
signal ccm_din1_2 : integer;		
signal ccm_din2_1 : integer;		
signal ccm_din2_2 : integer;		
signal ccm_din3_1 : integer;		
signal ccm_din3_2 : integer;		
signal ccm_din4_1 : integer;		
signal ccm_din4_2 : integer;		
signal ccm_din5_1 : integer;		
signal ccm_din5_2 : integer;		
signal ccm_din6_1 : integer;		
signal ccm_din6_2 : integer;		
signal ccm_din7_1 : integer;		
signal ccm_din7_2 : integer;		
signal ccm_din8_1 : integer;		
signal ccm_din8_2 : integer;		
signal ccm_din9_1 : integer;		
signal ccm_din9_2 : integer;		
signal ccm_din10_1 : integer;		
signal ccm_din10_2 : integer;		
signal ccm_din11_1 : integer;		
signal ccm_din11_2 : integer;		
signal ccm_din12_1 : integer;		
signal ccm_din12_2 : integer;		
signal ccm_din13_1 : integer;		
signal ccm_din13_2 : integer;		
signal ccm_din14_1 : integer;		
signal ccm_din14_2 : integer;		
signal ccm_din15_1 : integer;		
signal ccm_din15_2 : integer;		
signal ccm_din16_1 : integer;		
signal ccm_din16_2 : integer;		
-------------------------------------------------------------------------------- 
constant tb_clk: time := 10 ns;
begin

DUT_input_bus : pre_buffer_fsm port map
 (
	pre_buffer_fsm_clock      => clk,
	pre_buffer_fsm_reset      => reset, 
	pre_buffer_fsm_enable	 => enable,
	max_pooling_enable		 => max_pooling_enable,
	relu_enable				 => relu_enable,
	ccm_din_shift			 => ccm_din_shift,
	ccm_din_data_valid		 => ccm_din_data_valid,
	ccm_din1_1				 => ccm_din1_1,
	ccm_din1_2				 => ccm_din1_2,		
	ccm_din2_1				 => ccm_din2_1,		
	ccm_din2_2				 => ccm_din2_2,		
	ccm_din3_1				 => ccm_din3_1,		
	ccm_din3_2				 => ccm_din3_2,		
	ccm_din4_1				 => ccm_din4_1,		
	ccm_din4_2				 => ccm_din4_2,		
	ccm_din5_1				 => ccm_din5_1,		
	ccm_din5_2				 => ccm_din5_2,		
	ccm_din6_1				 => ccm_din6_1,		
	ccm_din6_2				 => ccm_din6_2,		
	ccm_din7_1				 => ccm_din7_1,		
	ccm_din7_2				 => ccm_din7_2,		
	ccm_din8_1				 => ccm_din8_1,		
	ccm_din8_2				 => ccm_din8_2,		
	ccm_din9_1				 => ccm_din9_1,		
	ccm_din9_2				 => ccm_din9_2,		
	ccm_din10_1				 => ccm_din10_1,		
	ccm_din10_2				 => ccm_din10_2,		
	ccm_din11_1				 => ccm_din11_1,		
	ccm_din11_2				 => ccm_din11_2,		
	ccm_din12_1				 => ccm_din12_1,		
	ccm_din12_2				 => ccm_din12_2,		
	ccm_din13_1				 => ccm_din13_1,		
	ccm_din13_2				 => ccm_din13_2,		
	ccm_din14_1				 => ccm_din14_1,		
	ccm_din14_2				 => ccm_din14_2,		
	ccm_din15_1				 => ccm_din15_1,		
	ccm_din15_2				 => ccm_din15_2,		
	ccm_din16_1				 => ccm_din16_1,		
	ccm_din16_2				 => ccm_din16_2		
 );

	




	clk_process : process

	begin
	  clk <= '0';
	  wait for tb_clk;
	  clk <= '1';
	  wait for tb_clk;	 
	end process;


	process
	begin

	wait for 9 ns;
	enable  <= '0';
	reset  <= '1';


	wait for 5 ns;
	enable  <= '1';


	wait for 1 ns;
	reset  <= '0';

	wait for 35 ns;
	ccm_din_data_valid  <= '1';
		max_pooling_enable  <= '1';
		relu_enable  <= '1';
		ccm_din1_1  <= 10;	
		ccm_din1_2  <= -10;	
		ccm_din2_1  <= -10;	
		ccm_din2_2  <= -10;	
		ccm_din3_1  <= -10;	
		ccm_din3_2  <= 10;	
		ccm_din4_1  <= 10;	
		ccm_din4_2  <= 10;	
		ccm_din5_1  <= 10;	
		ccm_din5_2  <= 10;	
		ccm_din6_1  <= 10;	
		ccm_din6_2  <= 10;	
		ccm_din7_1  <= 10;	
		ccm_din7_2  <= 10;	
		ccm_din8_1  <= 10;	
		ccm_din8_2  <= 10;	
		ccm_din9_1  <= 10;	
		ccm_din9_2  <= 10;	
		ccm_din10_1  <= 10;	
		ccm_din10_2  <= 10;	
		ccm_din11_1  <= 10;	
		ccm_din11_2  <= 10;	
		ccm_din12_1  <= 10;	
		ccm_din12_2  <= 10;	
		ccm_din13_1  <= 10;	
		ccm_din13_2  <= 10;	
		ccm_din14_1  <= 10;	
		ccm_din14_2  <= 10;	
		ccm_din15_1  <= 10;	
		ccm_din15_2  <= 10;	
		ccm_din16_1  <= 10;	
		ccm_din16_2  <= 10;	

	wait for 20 ns;
	ccm_din_data_valid  <= '0';

	wait for 120 ns;
	max_pooling_enable  <= '1';
	relu_enable  <= '1';
	ccm_din_data_valid  <= '1';
	ccm_din1_1  <= 9;	
	ccm_din1_2  <= -9;	
	ccm_din2_1  <= 9;	
	ccm_din2_2  <= -9;	
	ccm_din3_1  <= 9;	
	ccm_din3_2  <= 9;	
	ccm_din4_1  <= 9;	
	ccm_din4_2  <= 9;	
	ccm_din5_1  <= 9;	
	ccm_din5_2  <= 9;	
	ccm_din6_1  <= 9;	
	ccm_din6_2  <= 9;	
	ccm_din7_1  <= 9;	
	ccm_din7_2  <= 9;	
	ccm_din8_1  <= 9;	
	ccm_din8_2  <= 9;	
	ccm_din9_1  <= 9;	
	ccm_din9_2  <= 9;	
	ccm_din10_1  <= 9;	
	ccm_din10_2  <= 9;	
	ccm_din11_1  <= 9;	
	ccm_din11_2  <= 9;	
	ccm_din12_1  <= 9;	
	ccm_din12_2  <= 9;	
	ccm_din13_1  <= 9;	
	ccm_din13_2  <= 9;	
	ccm_din14_1  <= 9;	
	ccm_din14_2  <= -9;	
	ccm_din15_1  <= -9;	
	ccm_din15_2  <= -9;	
	ccm_din16_1  <= -9;	
	ccm_din16_2  <= -9;	

	wait for 20 ns;
	ccm_din_data_valid  <= '0';



	wait;
	end process;

end tb_pre_buffer_fsm_arc;


