LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;

entity tb_pixel_memory_bank is
end tb_pixel_memory_bank;


architecture tb_pixel_memory_bank_arc of tb_pixel_memory_bank is



	component pixel_memory_bank
	port (
		bank_clk 					: in std_logic;
		bank_reset 					: in std_logic;
		bank_dram_data	 			: in STD_LOGIC_VECTOR (bus_width-1 downto 0);
		read_array 					: in STD_LOGIC_VECTOR (pixel_memory_bank_number-1 downto 0);
		write_array					: in STD_LOGIC_VECTOR (pixel_memory_bank_number-1 downto 0);
		bank_read_address       	: in STD_LOGIC_VECTOR (SIZE_sram_address+1 downto 0);
		bank_enable					: in std_logic_vector (pixel_memory_bank_number-1 downto 0);
		bank_full					: out std_logic_vector (pixel_memory_bank_number-1 downto 0);	
		pixel_value 				: out STD_LOGIC_VECTOR (SM_segment_bit-1 downto 0);
		bank_row_starting_address	: out STD_LOGIC_VECTOR (SIZE_sram_address-1 downto 0)
	);	
	end component;
	

	signal tb_bank_clk  				: std_logic;
	signal tb_bank_reset 				: std_logic;
	signal tb_bank_dram_data 			: std_logic_vector (bus_width-1 downto 0);
	signal tb_read_array 				: STD_LOGIC_VECTOR (pixel_memory_bank_number-1 downto 0);
	signal tb_write_array				: STD_LOGIC_VECTOR (pixel_memory_bank_number-1 downto 0);
	signal tb_bank_read_address      	: STD_LOGIC_VECTOR (SIZE_sram_address+1 downto 0);
	signal tb_bank_enable				: std_logic_vector (pixel_memory_bank_number-1 downto 0);
	signal tb_bank_full					: std_logic_vector (pixel_memory_bank_number-1 downto 0);
	signal tb_pixel_value				: std_logic_vector (SM_segment_bit-1 downto 0);
	signal tb_starting_address			: std_logic_vector (SIZE_sram_address-1 downto 0);
	constant tb_clk : time := 10ns;

begin

	DUT : pixel_memory_bank port map (
				bank_clk => tb_bank_clk,							
				bank_reset => tb_bank_reset, 				
				bank_dram_data	 		=> tb_bank_dram_data,
				read_array 				=> tb_read_array,
				write_array				=> tb_write_array,
				bank_read_address       => tb_bank_read_address,
				bank_enable				=> tb_bank_enable,
				bank_full				=> tb_bank_full,
				pixel_value 			=> tb_pixel_value,
				bank_row_starting_address => tb_starting_address
				);

	CLK_process : process

	begin
	  tb_bank_clk <= '0';
	  wait for tb_clk;
	  tb_bank_clk <= '1';
	  wait for tb_clk;	 
	end process;



	process
	begin

--------------------------------------------------------------------------------
--  testing block for writing into pixel bank                                 --
--------------------------------------------------------------------------------

		tb_bank_reset 		<= '1';
		tb_bank_dram_data 	<= x"00110001";
		tb_read_array 		<= "0000";
		tb_write_array 		<= "0001";
		tb_bank_enable 		<= "0000";
		wait for 20ns;

		tb_bank_reset 		<= '1';
		tb_bank_dram_data 	<= x"00110001";
		tb_read_array 		<= "0000";
		tb_write_array 		<= "0001";
		tb_bank_enable 		<= "0000";
		wait for 20ns;

		tb_bank_reset 		<= '0';
		tb_bank_dram_data 	<= x"00110001";
		tb_read_array 		<= "0000";
		tb_write_array 		<= "0001";
		tb_bank_enable 		<= "0001";
		wait for 20ns;

		tb_bank_reset 		<= '0';
		tb_bank_dram_data 	<= x"00110001";
		tb_read_array 		<= "0000";
		tb_write_array 		<= "0010";
		tb_bank_enable 		<= "0010";
		wait for 20ns;

		tb_bank_reset 		<= '0';
		tb_bank_dram_data 	<= x"00110001";
		tb_read_array 		<= "0000";
		tb_write_array 		<= "0100";
		tb_bank_enable 		<= "0100";
		wait for 20ns;

		tb_bank_reset 		<= '0';
		tb_bank_dram_data 	<= x"00110001";
		tb_read_array		 <= "0000";
		tb_write_array 		<= "1000";
		tb_bank_enable 		<= "1000";
		wait for 20ns;

		tb_bank_reset 		<= '0';
		tb_bank_dram_data 	<= x"00000000";
		tb_read_array 		<= "0000";
		tb_write_array 		<= "0001";
		tb_bank_enable 		<= "0000";
		wait for 20ns;

		wait;
	end process;



end tb_pixel_memory_bank_arc;