LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
use work.func_external.all;

-----------------------------------------------------------

entity tb_mac_control is
end entity ;

-----------------------------------------------------------

architecture testbench of tb_mac_control is

	component mac_control is
	port (
		pixel_value			: in integer;
		--pixel_valid 		: in integer;
		mac_control_clk					: in std_logic;
		mac_control_reset				: in std_logic;
		mac_control_enable				: in std_logic;
		mac_control_compute_done		: in std_logic;
		pixel_x 			            :in integer;
		pixel_y 			            :in integer;
		pixel_z 			            :in integer;
		stripe_status                   :in std_logic;

		control_x 			            :out integer;
		control_y 			            :out integer;
		control_z 			            :out integer;
		address_done					:out std_logic;
		--control_pixel_valid				:out integer;
		control_pixel		            :out integer;
		control_kernel_address_ready    :out integer;
		control_kernel_address			:out integer
	);
	end component;


	constant tb_clk : time := 10 ns ; -- NS
	signal reset,enable,mac_control_compute_done : std_logic;
	signal control_pixel : integer;
	signal clk: std_logic;
	signal pixel_value ,pixel_x,pixel_y,pixel_z,control_x,control_y,control_z : integer;
	signal kernel_address,kernel_address_ready : integer;
	signal stripe_status ,address_done: std_logic;
	--signal pixel_valid : integer;

begin

	dut: mac_control port map (
		pixel_value			             => pixel_value,
		mac_control_clk			         => clk,
		mac_control_reset	             => reset,
		mac_control_enable	             => enable,
		mac_control_compute_done         => mac_control_compute_done,
		pixel_x				             => pixel_x,
		pixel_y				             => pixel_y,
		pixel_z				             => pixel_z,
		--pixel_valid			             => pixel_valid,
		stripe_status					 => stripe_status,
		address_done					 => address_done,

		control_kernel_address           => kernel_address,
		control_kernel_address_ready 	 => kernel_address_ready,
		control_pixel		             => control_pixel,
		--control_pixel_valid				 => control_pixel_valid,
		control_x			             => control_x,
		control_y			             => control_y,
		control_z			             => control_z

		);
-----------------------------------------------------------
-- Clocks and Reset
-----------------------------------------------------------
	CLK_process : process

	begin
	  clk <= '0';
	  wait for tb_clk;
	  clk <= '1';
	  wait for tb_clk;	 
	end process;

--------------------------------------------------------------------------------
-- stimuli
--------------------------------------------------------------------------------

	process
	begin
		mac_control_compute_done  <= '0';
		stripe_status  <= '0';
		--pixel_valid  <= '1';
		enable  <= '0';
		reset  <= '1';

		wait for 29  ns;
		reset  <= '0';
		--enable  <= '1';

		wait for 20 ns;

		enable   <= '1';
		wait for 21 ns;

		
		pixel_x  <= 1;
		pixel_y  <= 0;
		pixel_z  <= 0; 

		wait for 140 ns;
		pixel_x  <= 1;
		pixel_y  <= 4;
		pixel_z  <= 0; 
		
		wait for 140 ns;
		pixel_x  <= 0;
		pixel_y  <= 0;
		pixel_z  <= 0; 
		mac_control_compute_done  <= '1';
		wait for 20 ns;
		mac_control_compute_done  <= '0';

		wait for 140 ns;
		pixel_x  <= 0;
		pixel_y  <= 0;
		pixel_z  <= 2; 
		
		wait for 120 ns;
		pixel_x  <= 1;
		pixel_y  <= 1;
		pixel_z  <= 0; 
		
		wait for 120 ns;
		pixel_x  <= 1;
		pixel_y  <= 1;
		pixel_z  <= 3; 
		
		wait for 120 ns;
		pixel_x  <= 1;
		pixel_y  <= 3;
		pixel_z  <= 0; 
		
		wait for 120 ns;
		pixel_x  <= 3;
		pixel_y  <= 3;
		pixel_z  <= 0; 
		

		wait;
		
	end process ;



end architecture testbench;