library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use std.textio.all;
use ieee.std_logic_textio.all;
use work.constants.all;


--------------------------------------------------------------------------------
-- Function
-- 1.test the functionality of sram_kernel
-- 2.sram_kernel reads the data from "data.txt" at every falling edge of the clock
-- 3.sram_kernel will write data to memory, and the memory accept the data at every rising edge of the clock
--------------------------------------------------------------------------------


entity tb_mac_ccm is
end tb_mac_ccm;



architecture beh of tb_mac_ccm is

	component mac_ccm is
		  port(  

        mac_kernel_value    : in integer;
        mac_pixel_value     : in integer;
        mac_kernel_valid    : in std_logic;
        mac_pixel_valid     : in std_logic;
        mac_clk         : in std_logic;
        mac_reset       : in std_logic;
        mac_enable        : in std_logic;
        one_stripe_done : in integer;
        mac_x       :in integer;
        mac_y       :in integer;
        mac_z       :in integer;

        compute_done_out: out integer;
        output0     : out integer;
        output1     : out integer
     );
	end component;

	signal clk   : std_logic;
	signal reset   : std_logic;
	signal enable : std_logic;
  signal kernel_valid,pixel_valid : std_logic;
  signal kernel_value,pixel_value : integer;
  signal output0,output1 : integer;
  signal x,y,z,one_stripe_done,compute_done_out : integer;

	constant tb_clk : time := 10 ns;

begin

	DUT: mac_ccm port map (    

     mac_kernel_value    => kernel_value,
     mac_kernel_valid    => kernel_valid,
     mac_pixel_value     => pixel_value,
     mac_pixel_valid     => pixel_valid,
     mac_clk             => clk,
     mac_reset           => reset,
     mac_enable          => enable,
     mac_x               => x,
     mac_y               => y,
     mac_z               => z,
     one_stripe_done     => one_stripe_done,

     compute_done_out    => compute_done_out, 
     output0             => output0,
     output1             => output1
      );

  CLK_process : process

    begin

      clk <= '0';

      wait for tb_clk;

      clk <= '1';

      wait for tb_clk;
 
     end process;

    process
    begin

     enable  <= '0' ;
     reset    <= '1';
     one_stripe_done  <= 0;

     wait for 28 ns;
     
     reset  <= '0';

     wait for 1 ns;

     enable  <= '1';

     wait for 21 ns;

     kernel_valid  <= '1';
     pixel_valid  <= '1';
     kernel_value  <= 1 ;
     pixel_value  <= 1;
     x  <= 0;
     y  <= 0;
     z  <= 0;

     wait for 40 ns;

     kernel_valid  <= '1';
     pixel_valid  <= '1';
     kernel_value  <= 1 ;
     pixel_value  <= 2;
     x  <= 0;
     y  <= 1;
     z  <= 0;

     wait for 60 ns;

     kernel_valid  <= '1';
     pixel_valid  <= '1';
     kernel_value  <= 1 ;
     pixel_value  <= 3;
     x  <= 0;
     y  <= 2;
     z  <= 0;

     wait for 80 ns;

     kernel_valid  <= '1';
     pixel_valid  <= '1';
     kernel_value  <= 1 ;
     pixel_value  <= 3;
     x  <= 0;
     y  <= 3;
     z  <= 0;

     wait for 120 ns;

     kernel_valid  <= '1';
     pixel_valid  <= '1';
     kernel_value  <= 1 ;
     pixel_value  <= 4;
     x  <= 0;
     y  <= 4;
     z  <= 0;

     wait for 100 ns;     

     kernel_valid  <= '1';
     pixel_valid  <= '1';
     kernel_value  <= 1 ;
     pixel_value  <= 5;
     x  <= 0;
     y  <= 5;
     z  <= 0;

     wait for 60 ns;


     wait;

     end process;



end beh;

