LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
use work.func_external.all;


entity tb_locator is
end tb_locator;



architecture beh of tb_locator is

	component locator is
		  port(  

		  	fsm0_data    : in integer;
		  	fsm1_data    : in integer;
		  	fsm2_data    : in integer;
		  	fsm3_data    : in integer;
		  	fsm0_valid   : in integer;
		  	fsm1_valid   : in integer;
		  	fsm2_valid   : in integer;
		  	fsm3_valid   : in integer;
		  	fsm0_x 		 : in integer;
		  	fsm0_y 		 : in integer;
		  	fsm0_z 		 : in integer;
		  	fsm1_x 		 : in integer;
		  	fsm1_y 		 : in integer;
		  	fsm1_z 		 : in integer;
		  	fsm2_x 		 : in integer;
		  	fsm2_y 		 : in integer;
		  	fsm2_z 		 : in integer;
		  	fsm3_x 		 : in integer;
		  	fsm3_y 		 : in integer;
		  	fsm3_z 		 : in integer;
		  	loc_compute_done  : in integer;
		  	locator_clk  : in std_logic;
		  	locator_en   : in std_logic;
		  	locator_rst  : in std_logic;

		  	pixel_value  : out integer;
		  	data_valid   : out integer;
		  	pixel_x      : out integer;
		  	pixel_y      : out integer;
		  	pixel_z      : out integer
     );
	end component;

  signal locator_rst,locator_clk,locator_en   : std_logic;
  signal fsm0_data,fsm1_data,fsm2_data,fsm3_data, pixel_valid : integer;
  signal data_valid,pixel_x,pixel_y ,pixel_z : integer;
  signal loc_compute_done : integer;
  signal fsm0_valid,fsm1_valid,fsm2_valid,fsm3_valid,fsm0_x,fsm0_y,	fsm0_z,fsm1_x, fsm1_y, fsm1_z, fsm2_x, fsm2_y, fsm2_z, fsm3_x, fsm3_y, fsm3_z : integer; 		
  signal pixel_value : integer;
  constant tb_clk : time := 10 ns;

begin

	DUT: locator port map (    

     fsm0_data     =>    fsm0_data,     
     fsm1_data     =>    fsm1_data,   
     fsm2_data     =>    fsm2_data,   
     fsm3_data     =>    fsm3_data,   
     fsm0_valid    =>     fsm0_valid,  
     fsm1_valid    =>     fsm1_valid,  
     fsm2_valid    =>     fsm2_valid,  
     fsm3_valid    =>     fsm3_valid,  
     fsm0_x        =>   fsm0_x, 		
     fsm0_y        =>   fsm0_y, 		
     fsm0_z        =>   fsm0_z, 		
     fsm1_x        =>   fsm1_x, 		
     fsm1_y        =>   fsm1_y, 		
     fsm1_z        =>   fsm1_z, 		
     fsm2_x        =>   fsm2_x, 		
     fsm2_y        =>   fsm2_y, 		
     fsm2_z        =>   fsm2_z, 		
     fsm3_x        =>   fsm3_x, 		
     fsm3_y        =>   fsm3_y, 		
     fsm3_z        =>   fsm3_z, 		
     loc_compute_done   =>    loc_compute_done, 
     locator_clk   =>    locator_clk, 
     locator_en    =>    locator_en,  
     locator_rst   =>    locator_rst, 
     pixel_value   =>    pixel_value, 
     data_valid    =>    data_valid,  
     pixel_x       =>     pixel_x,     
     pixel_y       =>     pixel_y,     
     pixel_z       =>     pixel_z     
      );

  CLK_process : process

    begin

      locator_clk <= '0';

      wait for tb_clk;

      locator_clk <= '1';

      wait for tb_clk;
 
     end process;

    process
    begin

     locator_en  <= '0' ;
     locator_rst    <= '1';
     fsm0_valid  <= 0;
     fsm1_valid  <= 0;
     fsm2_valid  <= 0;
     fsm3_valid  <= 0;

     wait for 28 ns;
     
     locator_rst  <= '0';

     wait for 1 ns;

     locator_en  <= '1';

     wait for 21 ns;

    fsm0_data  <= 0; 
    fsm1_data  <= 1; 
    fsm2_data  <= 2; 
    fsm3_data  <= 3; 
     fsm0_valid  <= 0;
     fsm1_valid  <= 1;
     fsm2_valid  <= 1;
     fsm3_valid  <= 1;


    loc_compute_done  <= 0;

    wait for 60 ns;
    fsm0_data  <= 0; 
    fsm1_data  <= 1; 
    fsm2_data  <= 2; 
    fsm3_data  <= 3; 

    loc_compute_done  <= 1;

    wait for 20 ns;
    fsm0_data  <= 0; 
    fsm1_data  <= 1; 
    fsm2_data  <= 2; 
    fsm3_data  <= 3; 

    loc_compute_done  <= 0;

    wait for 60 ns;
    fsm0_data  <= 0; 
    fsm1_data  <= 1; 
    fsm2_data  <= 2; 
    fsm3_data  <= 3; 

    loc_compute_done  <= 1;

    wait for 20 ns;
    fsm0_data  <= 0; 
    fsm1_data  <= 1; 
    fsm2_data  <= 2; 
    fsm3_data  <= 3; 

    loc_compute_done  <= 0;

    wait for 80 ns;
    fsm0_data  <= 0; 
    fsm1_data  <= 1; 
    fsm2_data  <= 2; 
    fsm3_data  <= 3; 

    loc_compute_done  <= 1;

    wait for 20 ns;
    fsm0_data  <= 0; 
    fsm1_data  <= 1; 
    fsm2_data  <= 2; 
    fsm3_data  <= 3; 

    loc_compute_done  <= 0;

    wait for 60 ns;
    fsm0_data  <= 0; 
    fsm1_data  <= 1; 
    fsm2_data  <= 2; 
    fsm3_data  <= 3; 

    loc_compute_done  <= 1;

    wait for 20 ns;
    fsm0_valid  <= 1;
    fsm1_valid  <= 0;
    fsm2_valid  <= 0;
    fsm3_valid  <= 0;

    wait for 20 ns; 
    fsm0_valid  <= 0;
    fsm1_valid  <= 1;
    fsm2_valid  <= 0;
    fsm3_valid  <= 0;

    wait for 20 ns; 
    fsm0_valid  <= 0;
    fsm1_valid  <= 0;
    fsm2_valid  <= 0;
    fsm3_valid  <= 0;

     wait;

     end process;



end beh;

