library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use std.textio.all;
use ieee.std_logic_textio.all;
use work.constants.all;
use work.func_external.all;


-----------------------------------------------------------

entity tb_input_tracker_tracker_memory is
end entity ;

-----------------------------------------------------------

architecture testbench of tb_input_tracker_tracker_memory is

component SRAM_tracker 
	Port ( 

	    sram_clk                       : in  STD_LOGIC;
	    sram_reset                     : in  STD_LOGIC;
	    start_add0                 : in  unsigned (SIZE_sram_address - 1 downto 0);
	    start_add1                 : in  unsigned (SIZE_sram_address - 1 downto 0);
	    start_add2                 : in  unsigned (SIZE_sram_address - 1 downto 0);
	    start_add3                 : in  unsigned (SIZE_sram_address - 1 downto 0);
	    start_add4                 : in  unsigned (SIZE_sram_address - 1 downto 0);
	    start_add5                 : in  unsigned (SIZE_sram_address - 1 downto 0);
	    start_add6                 : in  unsigned (SIZE_sram_address - 1 downto 0);
	    start_add7                 : in  unsigned (SIZE_sram_address - 1 downto 0);
	    sram_read_address0         : in  STD_LOGIC_VECTOR (tracker_sram_size - 1 downto 0);
	    sram_read_address1         : in  STD_LOGIC_VECTOR (tracker_sram_size - 1 downto 0);
	    sram_read_address2         : in  STD_LOGIC_VECTOR (tracker_sram_size - 1 downto 0);
	    sram_read_address3         : in  STD_LOGIC_VECTOR (tracker_sram_size - 1 downto 0);
	    sram_read_address4         : in  STD_LOGIC_VECTOR (tracker_sram_size - 1 downto 0);
	    sram_read_address5         : in  STD_LOGIC_VECTOR (tracker_sram_size - 1 downto 0);
	    sram_read_address6         : in  STD_LOGIC_VECTOR (tracker_sram_size - 1 downto 0);
	    sram_read_address7         : in  STD_LOGIC_VECTOR (tracker_sram_size - 1 downto 0);
	    sram_write_en             : in  integer;
	    sram_read_en              : in  STD_LOGIC;
	    sram_enable               : in  STD_LOGIC;
	    start_add_out0            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
	    start_add_out1            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
	    start_add_out2            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
	    start_add_out3            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
	    start_add_out4            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
	    start_add_out5            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
	    start_add_out6            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
	    start_add_out7            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
	    sram_read_data_valid      : out std_logic
	);
end component;




component input_tracker
	port (
		tracker_clk           : in std_logic;
		tracker_reset         : in std_logic;
		tracker_enable        : in std_logic;
		input_tracker_in     : in std_logic_vector (bus_width-1 downto 0);
		bus_index_signal : in integer;

		tracker_out_address_0 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_1 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_2 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_3 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_4 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_5 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_6 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_7 : out unsigned (SIZE_sram_address-1 downto 0);
		stripe_done : out integer
);
end component;

component input_bus
    port(    bus_clk : IN std_logic;
             bus_reset : in std_logic;  
             bus_enable : in std_logic;   
             bus_index : out integer;

 			 dram_data_valid : out std_logic;
             dram_data : OUT std_logic_vector (bus_width-1 downto 0) 
     );
end component;



signal reset          : std_logic;
signal clk            : std_logic;
signal outputaddress0 : unsigned (SIZE_sram_address-1 downto 0);
signal outputaddress1 : unsigned (SIZE_sram_address-1 downto 0);
signal outputaddress2 : unsigned (SIZE_sram_address-1 downto 0);
signal outputaddress3 : unsigned (SIZE_sram_address-1 downto 0);
signal outputaddress4 : unsigned (SIZE_sram_address-1 downto 0);
signal outputaddress5 : unsigned (SIZE_sram_address-1 downto 0);
signal outputaddress6 : unsigned (SIZE_sram_address-1 downto 0);
signal outputaddress7 : unsigned (SIZE_sram_address-1 downto 0);

signal test_bus_enable      : std_logic;
signal datain         : std_logic_vector (bus_width-1 downto 0);
signal dram_data_valid : std_logic;
signal bus_index_signal : integer;
signal stripe_done : integer;



signal read_address0,read_address1,read_address2,read_address3,read_address4,read_address5,read_address6,read_address7 : std_logic_vector ( tracker_sram_size-1 downto 0);
signal add_out0,add_out1,add_out2,add_out3,add_out4,add_out5,add_out6,add_out7 : std_logic_vector (SIZE_sram_address-1 downto 0);
signal sram_read_en,sram_read_data_valid : std_logic;


constant tb_clk       : time := 10ns;

begin

		dut_input_bus : input_bus port map(
			bus_clk        => clk,
			bus_reset      => reset,
			bus_enable => test_bus_enable,   

			dram_data_valid  => dram_data_valid,
			dram_data  => datain,
			bus_index  => bus_index_signal

		);



	dut_input_tracker: input_tracker port map(
		tracker_clk           => clk,
		tracker_reset         => reset,
		tracker_enable        => test_bus_enable,
		bus_index_signal   =>  bus_index_signal,

		input_tracker_in      => datain,
		tracker_out_address_0 => outputaddress0,
		tracker_out_address_1 => outputaddress1,
		tracker_out_address_2 => outputaddress2,
		tracker_out_address_3 => outputaddress3,
		tracker_out_address_4 => outputaddress4,
		tracker_out_address_5 => outputaddress5,
		tracker_out_address_6 => outputaddress6,
		tracker_out_address_7 => outputaddress7,
		stripe_done 	 => stripe_done
		);


	dut_sram_tracker : SRAM_tracker port map(
	sram_clk  => clk,           
	sram_reset  => reset,         
	start_add0  => outputaddress0,          
	start_add1  => outputaddress1,          
	start_add2  => outputaddress2,          
	start_add3  => outputaddress3,          
	start_add4  => outputaddress4,          
	start_add5  => outputaddress5,          
	start_add6  => outputaddress6,          
	start_add7  => outputaddress7,          
	      
	sram_read_address0  => read_address0,  
	sram_read_address1  => read_address1,  
	sram_read_address2  => read_address2,  
	sram_read_address3  => read_address3,  
	sram_read_address4  => read_address4,  
	sram_read_address5  => read_address5,  
	sram_read_address6  => read_address6, 
	sram_read_address7  => read_address7,  
	sram_write_en     => stripe_done,   
	sram_read_en	 => sram_read_en,        
	sram_enable       => test_bus_enable,   
	start_add_out0	 => add_out0,      
	start_add_out1	 => add_out1,      
	start_add_out2	 => add_out2,      
	start_add_out3	 => add_out3,      
	start_add_out4	 => add_out4,      
	start_add_out5	 => add_out5,      
	start_add_out6	 => add_out6,      
	start_add_out7	 => add_out7,      
	sram_read_data_valid	 => sram_read_data_valid
	);

	CLK_process : process

	begin
	  clk <= '0';
	  wait for tb_clk;
	  clk <= '1';
	  wait for tb_clk;	 
	end process;


--process(clk)
--begin
-- if rising_edge(clk) then

--	 outputaddress0_con  <= outputaddress0; 
--	 outputaddress1_con  <= outputaddress1;
--	 outputaddress2_con  <= outputaddress2;
--	 outputaddress3_con  <= outputaddress3;
--	 outputaddress4_con  <= outputaddress4;
--	 outputaddress5_con  <= outputaddress5;
--	 outputaddress6_con  <= outputaddress6;
--	 outputaddress7_con  <= outputaddress7;
-- end if;
--end process;
process
begin
	reset <= '1', '0' after 19ns;
	test_bus_enable <= '0', '1'after 35ns;



	wait;


end process;


end architecture testbench;