library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use std.textio.all;
use ieee.std_logic_textio.all;
use work.constants.all;


-----------------------------------------------------------

entity tb_input_tracker is
end entity ;

-----------------------------------------------------------

architecture testbench of tb_input_tracker is

component input_tracker
	port (
		tracker_clk           : in std_logic;
		tracker_reset         : in std_logic;
		tracker_enable        : in std_logic;
		input_tracker_in     : in std_logic_vector (bus_width-1 downto 0);
		bus_index_signal : in integer;

		tracker_out_address_0 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_1 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_2 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_3 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_4 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_5 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_6 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_7 : out unsigned (SIZE_sram_address-1 downto 0);
		stripe_done : out integer
);
end component;

component input_bus
    port(    bus_clk : IN std_logic;
             bus_reset : in std_logic;  
             bus_enable : in std_logic;   
             bus_index : out integer;

 			 dram_data_valid : out std_logic;
             dram_data : OUT std_logic_vector (bus_width-1 downto 0) 
     );
end component;



signal reset          : std_logic;
signal clk            : std_logic;
signal outputaddress0 : unsigned (SIZE_sram_address-1 downto 0);
signal outputaddress1 : unsigned (SIZE_sram_address-1 downto 0);
signal outputaddress2 : unsigned (SIZE_sram_address-1 downto 0);
signal outputaddress3 : unsigned (SIZE_sram_address-1 downto 0);
signal outputaddress4 : unsigned (SIZE_sram_address-1 downto 0);
signal outputaddress5 : unsigned (SIZE_sram_address-1 downto 0);
signal outputaddress6 : unsigned (SIZE_sram_address-1 downto 0);
signal outputaddress7 : unsigned (SIZE_sram_address-1 downto 0);

signal test_tracker_enable      : std_logic;
signal test_bus_enable      : std_logic;
signal datain         : std_logic_vector (bus_width-1 downto 0);
signal dram_data_valid : std_logic;
signal bus_index_signal : integer;
signal stripe_done : integer;
constant tb_clk       : time := 10ns;

begin

		dut_input_bus : input_bus port map(
			bus_clk        => clk,
			bus_reset      => reset,
			bus_enable => test_bus_enable,   

			dram_data_valid  => dram_data_valid,
			dram_data  => datain,
			bus_index  => bus_index_signal

		);



	dut_input_tracker: input_tracker port map(
		tracker_clk           => clk,
		tracker_reset         => reset,
		tracker_enable        => test_bus_enable,
		bus_index_signal   =>  bus_index_signal,

		input_tracker_in      => datain,
		tracker_out_address_0 => outputaddress0,
		tracker_out_address_1 => outputaddress1,
		tracker_out_address_2 => outputaddress2,
		tracker_out_address_3 => outputaddress3,
		tracker_out_address_4 => outputaddress4,
		tracker_out_address_5 => outputaddress5,
		tracker_out_address_6 => outputaddress6,
		tracker_out_address_7  => outputaddress7,
		stripe_done 	 => stripe_done
		);





	CLK_process : process

	begin
	  clk <= '0';
	  wait for tb_clk;
	  clk <= '1';
	  wait for tb_clk;	 
	end process;

process
begin
	reset <= '1', '0' after 19ns;
	test_bus_enable <= '0', '1'after 35ns;



	wait;


end process;


end architecture testbench;