library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use std.textio.all;
use ieee.std_logic_textio.all;
use work.constants.all;


--------------------------------------------------------------------------------
-- Function
-- 1.test the functionality of input_bus
-- 2.input_bus reads the data from "data.txt" at every falling edge of the clock
-- 3.input_bus will write data to memory, and the memory accept the data at every rising edge of the clock
--------------------------------------------------------------------------------


entity tb_input_bus is
end tb_input_bus;



architecture tb_bus_arc of tb_input_bus is

	component input_bus is
		  port(  bus_clk : IN std_logic;
             bus_enable : in std_logic;   
             bus_index :out integer;
             bus_reset : in std_logic;   
             dram_data_valid : out std_logic;
             dram_data : OUT std_logic_vector (bus_width-1 downto 0) 
     );
	end component;

	signal tb_out : std_logic_vector (bus_width-1 downto 0);
	signal bus_clk   : std_logic;
	signal bus_reset   : std_logic;
	signal bus_enable : std_logic;
  signal dram_data_valid : std_logic;
  signal bus_index : integer;
	constant tb_clk : time := 10 ns;

begin

	DUT: input_bus port map (     bus_clk => bus_clk, 
                                bus_enable  => bus_enable,   
                                bus_index  => bus_index,
                                dram_data_valid  => dram_data_valid,
																bus_reset => bus_reset, 
																dram_data => tb_out );

  CLK_process : process

    begin

      bus_clk <= '0';

      wait for tb_clk;

      bus_clk <= '1';

      wait for tb_clk;
 
     end process;

    process
    begin

     bus_enable  <= '0', '1' after 39 ns;


     bus_reset   <= '1', '0' after 29 ns;

     wait for 200ns;

     wait;

     end process;

end tb_bus_arc;

