LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
use work.func_external.all;

entity tb_hammingweight is
end tb_hammingweight;


architecture test_arc of tb_hammingweight is

	component hammingweight is
	port (
		 hamming_clk   : in std_logic;
		 hammingweight_reset : in std_logic;
		 hammingweight_enable : in std_logic;

		 din   : in std_logic_vector (bus_width -1 downto 0);
		 hammingweight_result_1 	: out integer range 0 to 16;
		 hammingweight_result_2 	: out integer range 0 to 16 
		 );
	end component;
 
 signal CLK   : std_logic;
 signal reset : std_logic;
 signal start : std_logic;
 signal din   : std_logic_vector ( bus_width-1 downto 0);
 signal hammingweight_out1 : integer range 0 to 16;
 signal hammingweight_out2 : integer range 0 to 16;

 constant tb_clk : time := 10ns;

begin


	DUT: hammingweight port map (   
		 hamming_clk   =>  CLK,
		 hammingweight_reset =>reset,
		 hammingweight_enable =>start,

		 din   => din,
		 hammingweight_result_1 	=> hammingweight_out1,
		 hammingweight_result_2 	=> hammingweight_out2
		 
					);

  CLK_process : process

    begin

      CLK <= '0';

      wait for tb_clk;

      CLK <= '1';

      wait for tb_clk;
 
     end process;

process
begin	
	
	reset <='0';
	start <='1';
	wait for 10ns;

	reset <= '0';
	start <= '1';
  din <= x"ffff0000";
	wait for 20ns;
  
  reset <= '0';
	start <= '1';
	din <= x"fff00000";
	wait for 20ns;

	reset <= '0';
	start <= '1';
	din <= x"ff000000";
	wait for 20ns;

	reset <= '0';
	start <= '1';
	din <= x"0000ffff";
	wait for 20ns;

	reset <= '0';
	start <= '1';
	din <= x"00010000";
	wait for 20ns;
	
	reset <= '0';
	start <= '1';
	din <= x"11110000";
	wait for 20ns;
	
	wait;
end process;

		


end test_arc;