library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.func_external.all;
use work.constants.all;
-----------------------------------------------------------

entity   tb_func_external is
end entity ;

-----------------------------------------------------------

architecture testbench of tb_func_external  is

component input_bus
    port(    clk : IN std_logic;
             reset : in std_logic;   
             dram_data : OUT std_logic_vector (bus_width-1 downto 0) 
     );
end component;


component hammingweight
	port (
		 hamming_clk   : in std_logic;
		 hammingweight_reset : in std_logic;
		 hammingweight_enable : in std_logic;

		 din   : in std_logic_vector (bus_width -1 downto 0);
		 hammingweight_result_1 	: out integer range 0 to 16;
		 hammingweight_result_2 	: out integer range 0 to 16 
		 );
end component;

signal testsignal : std_logic_vector (31 downto 0);
signal  reset : std_logic;
signal clk: std_logic;
constant tb_clk : time := 10ns;
signal  output1 : integer;
signal  output2 : integer;
signal enable : std_logic;

begin



	dut : input_bus port map (
		    	clk => clk,
                reset => reset,
                dram_data => testsignal

	);

	dut2 :hammingweight port map (
		 hamming_clk   => clk,
		 hammingweight_reset => reset,
		 hammingweight_enable => enable,

		 din => testsignal, 
		 hammingweight_result_1 	=> output1,
		 hammingweight_result_2 	=>output2
		 );



		



	CLK_process : process

	begin
	  clk <= '0';
	  wait for tb_clk;
	  clk <= '1';
	  wait for tb_clk;	 
	end process;


process(clk) 
variable hammingweight : integer;

begin
	reset <= '0';
	enable <= '1';

end process;
	

end architecture testbench;