LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
use work.func_external.all;
-----------------------------------------------------------

entity tb_fsm_reg  is
end entity ;

-----------------------------------------------------------

architecture testbench of tb_fsm_reg is


component fsm_reg is
	port (
		fsm_reg_clock : in std_logic;
		fsm_reg_reset : in std_logic;
		fsm_reg_enable : in std_logic;
		fsm_reg_input_segment : in std_logic_vector (SM_segment_bit-1 downto 0);
		sm_valid             : out std_logic;
		fsm_reg_output_segment : out std_logic_vector (SM_segment_bit-1 downto 0)
		
	);
end component fsm_reg;

signal clk,enable,reset : std_logic;
signal input_segment,output_segment : std_logic_vector (SM_segment_bit-1 downto 0);
signal sm_valid : std_logic;

constant tb_clk: time := 10 ns;
begin
	-----------------------------------------------------------
	-- Clocks and Reset
	-----------------------------------------------------------
	CLK_GEN : process 
	begin
	  clk <= '0';
	  wait for tb_clk;
	  clk <= '1';
	  wait for tb_clk;	 
	end process;

	-----------------------------------------------------------
	-- Testbench Stimulus
	-----------------------------------------------------------

	process
	begin

	wait for 10 ns;

	reset  <= '1', '0' after 19 ns;
	enable  <= '0', '1' after 29 ns;
	input_segment  <= b"0000_1111_0000_1111";

	wait;
	end process;

	-----------------------------------------------------------
	-- Entity Under Test
	-----------------------------------------------------------
	dut_fsm_reg : fsm_reg port map
	(

		fsm_reg_clock   =>  clk,      
		fsm_reg_reset          => reset,
		fsm_reg_enable         => enable,
		fsm_reg_input_segment  => input_segment,
		sm_valid             => sm_valid,
		fsm_reg_output_segment  => output_segment
		);

end architecture testbench;