LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
use work.func_external.all;

entity tb_fsm_memory is
end tb_fsm_memory;

architecture tb_fsm_memory_arc of tb_fsm_memory is

component FSM is
	port (
		fsm_clock                   : in std_logic;
		fsm_reset                   : in std_logic;
		fsm_enable					: in std_logic;
		segment_valid 				: in std_logic;
		memory_address              : in std_logic_vector (SIZE_sram_address-1 downto 0);
		tracker_address             : in std_logic_vector (SIZE_sram_address-1 downto 0);
		memory_segment              : in std_logic_vector (memory_cell_width-1 downto 0);

		segment_done				: out std_logic;
		fsm_output_address          : out std_logic_vector (SIZE_sram_address-1 downto 0);
		memory_control_read_array   : out std_logic;    ------------------------WARNING:memory, to be changed when expand to mulltiple memory bank
		memory_control_write_array  : out std_logic 	------------------------WARNING:memory, to be changed when expand to mulltiple memory bank
	);
end component;


component SRAM 
    Port ( 

        clk                       : in  STD_LOGIC;
        reset                     : in  STD_LOGIC;
        dram_data                 : in  STD_LOGIC_VECTOR (bus_width - 1 downto 0);
        sram_read_address         : in  STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
        sram_write_en             : in  STD_LOGIC;
        sram_read_en              : in  STD_LOGIC;
        sram_enable               : in  STD_LOGIC;
        sram_full            : out  std_logic;
        sram_data            : out STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
        row_starting_address : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0)

    );


end component;
begin

DUT_input_bus: input_bus port map 
{
	


	
}



end tb_fsm_memory_arc;