LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
use work.func_external.all;

-----------------------------------------------------------

entity tb_controller is
end entity ;

-----------------------------------------------------------

architecture testbench of tb_controller is

	component controller is
	port (
		controller_clk		: in std_logic;
		controller_reset	: in std_logic;
		controller_enable	: in std_logic;
		pixel_value			: in unsigned (15 downto 0);
		pixel_x				: in integer;
		pixel_y				: in integer;
		pixel_z				: in integer;
		pixel_valid 		: in integer;

		control_kernel_address 		: out integer;
		control_kernel_address_ready 		: out integer;
		control_pixel		: out unsigned (15 downto 0);
		control_x			: out integer;
		control_y			: out integer;
		control_z			: out integer
	);
	end component;


	constant tb_clk : time := 10 ns ; -- NS
	signal reset,enable : std_logic;
	signal pixel_value,control_pixel : unsigned  (SM_segment_bit-1 downto 0);
	signal clk: std_logic;
	signal pixel_x,pixel_y,pixel_z,control_x,control_y,control_z : integer;
	signal kernel_address,kernel_address_ready : integer;
	signal pixel_valid : integer;


begin

	dut: controller port map (
		controller_clk		 => clk,
		controller_reset	 => reset,
		controller_enable	 => enable,
		pixel_value			 => pixel_value,
		pixel_x				 => pixel_x,
		pixel_y				 => pixel_y,
		pixel_z				 => pixel_z,
		pixel_valid			 => pixel_valid,

		control_kernel_address  => kernel_address,
		control_kernel_address_ready 	 => kernel_address_ready,
		control_pixel		 => control_pixel,
		control_x			 => control_x,
		control_y			 => control_y,
		control_z			 => control_z

		);
-----------------------------------------------------------
-- Clocks and Reset
-----------------------------------------------------------
	CLK_process : process

	begin
	  clk <= '0';
	  wait for tb_clk;
	  clk <= '1';
	  wait for tb_clk;	 
	end process;

--------------------------------------------------------------------------------
-- stimuli
--------------------------------------------------------------------------------

	process
	begin
		
		enable  <= '0';
		reset  <= '1';

		wait for 29  ns;
		reset  <= '0';
		--enable  <= '1';

		wait for 20 ns;

		enable   <= '1';
		wait for 21 ns;

		pixel_valid  <= 1;
		pixel_x  <= 1;
		pixel_y  <= 1;
		pixel_z  <= 0; 

		wait for 100 ns;
		pixel_x  <= 1;
		pixel_y  <= 62;
		pixel_z  <= 0; 
		
		wait for 100 ns;
		pixel_x  <= 62;
		pixel_y  <= 62;
		pixel_z  <= 0; 
		
		wait for 100 ns;
		pixel_x  <= 62;
		pixel_y  <= 1;
		pixel_z  <= 0; 
		
		wait for 100 ns;
		pixel_x  <= 0;
		pixel_y  <= 0;
		pixel_z  <= 0; 
		
		wait for 100 ns;
		pixel_x  <= 63;
		pixel_y  <= 63;
		pixel_z  <= 0; 
		
		wait for 100 ns;
		pixel_x  <= 0;
		pixel_y  <= 63;
		pixel_z  <= 0; 
		
		wait for 100 ns;
		pixel_x  <= 63;
		pixel_y  <= 0;
		pixel_z  <= 0; 
		

		wait;
		
	end process ;



end architecture testbench;