LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
use work.func_external.all;

-----------------------------------------------------------

entity tb_ccm is
end entity ;

-----------------------------------------------------------

architecture testbench of tb_ccm is

	component mac_control is
	port (
		pixel_value			: in integer;
		pixel_valid 		: in integer;
		mac_control_clk					: in std_logic;
		mac_control_reset				: in std_logic;
		mac_control_enable				: in std_logic;
		mac_control_stop				: in std_logic;
		pixel_x 			            :in integer;
		pixel_y 			            :in integer;
		pixel_z 			            :in integer;
		stripe_status                   :in std_logic;

		control_x 			            :out integer;
		control_y 			            :out integer;
		control_z 			            :out integer;
		address_done					:out std_logic;
		control_pixel		            :out integer;
		control_pixel_valid				:out integer;
		control_kernel_address_ready    :out integer;
		control_kernel_address			:out integer
	);
	end component;


	component locator is
		port (
			fsm0_data    : in integer;
			fsm1_data    : in integer;
			fsm2_data    : in integer;
			fsm3_data    : in integer;
			fsm0_valid   : in integer;
			fsm1_valid   : in integer;
			fsm2_valid   : in integer;
			fsm3_valid   : in integer;
			fsm0_x 		 : in integer;
			fsm0_y 		 : in integer;
			fsm0_z 		 : in integer;
			fsm1_x 		 : in integer;
			fsm1_y 		 : in integer;
			fsm1_z 		 : in integer;
			fsm2_x 		 : in integer;
			fsm2_y 		 : in integer;
			fsm2_z 		 : in integer;
			fsm3_x 		 : in integer;
			fsm3_y 		 : in integer;
			fsm3_z 		 : in integer;
			loc_compute_done  : in integer;
			locator_clk  : in std_logic;
			locator_en   : in std_logic;
			locator_rst  : in std_logic;

			pixel_value  : out integer;
			data_valid   : out integer;
			pixel_x      : out integer;
			pixel_y      : out integer;
			pixel_z      : out integer

		);
	end component locator;

	component mac_ccm is
		  port(  

        mac_kernel_value    : in integer;
        mac_pixel_value     : in integer;
        mac_kernel_valid    : in std_logic;
        mac_pixel_valid     : in integer;
        mac_clk         : in std_logic;
        mac_reset       : in std_logic;
        mac_enable        : in std_logic;
        one_stripe_done : in integer;
        mac_x       :in integer;
        mac_y       :in integer;
        mac_z       :in integer;

        compute_done_out: out integer;
        output0     : out integer;
        output1     : out integer
     );
	end component;

	component sram_kernel is
		port(  
			 kernel_clk : IN std_logic;
			 kernel_reset : in std_logic;
			 kernel_enable : in std_logic;
			 kernel_address : in integer;

			 kernel_data_valid : out std_logic;   
			 kernel_data : OUT signed (SM_segment_bit-1 downto 0) 
			);
	end component;



	constant tb_clk : time := 10 ns ; -- NS



--------------------------------------------------------------------------------locator
signal fsm0_data,fsm1_data,fsm2_data,fsm3_data, pixel_valid : integer;
signal pixel_x,pixel_y ,pixel_z : integer;
signal loc_compute_done : integer;
signal fsm0_valid,fsm1_valid,fsm2_valid,fsm3_valid,fsm0_x,fsm0_y,fsm0_z,fsm1_x, fsm1_y, fsm1_z, fsm2_x, fsm2_y, fsm2_z, fsm3_x, fsm3_y, fsm3_z : integer; 		
signal pixel_value, control_pixel_valid : integer;

--------------------------------------------------------------------------------locator

---------------------------------------------------------------------------------mac_control
signal reset,enable,stop : std_logic;
signal control_pixel : integer;
signal clk: std_logic;
signal control_x,control_y,control_z : integer;
signal kernel_address,kernel_address_ready : integer;
signal stripe_status ,address_done: std_logic;
--------------------------------------------------------------------------------mac_control

--------------------------------------------------------------------------------mac_ccm
signal kernel_valid : std_logic;
signal kernel_value : integer;
signal output0,output1 : integer;
signal x,y,z,one_stripe_done,compute_done_out : integer;
--------------------------------------------------------------------------------mac_ccm

--------------------------------------------------------------------------------sram_kernel
signal kernel_data : signed (SM_segment_bit-1 downto 0);
signal kernel_data_valid : std_logic;
--------------------------------------------------------------------------------sram_kernel
begin

kernel_value  <= to_integer(signed(kernel_data));

	locator_DUT: locator port map (    

	     fsm0_data     =>    fsm0_data,     
	     fsm1_data     =>    fsm1_data,   
	     fsm2_data     =>    fsm2_data,   
	     fsm3_data     =>    fsm3_data,   
	     fsm0_valid    =>     fsm0_valid,  
	     fsm1_valid    =>     fsm1_valid,  
	     fsm2_valid    =>     fsm2_valid,  
	     fsm3_valid    =>     fsm3_valid,  
	     fsm0_x        =>   fsm0_x, 		
	     fsm0_y        =>   fsm0_y, 		
	     fsm0_z        =>   fsm0_z, 		
	     fsm1_x        =>   fsm1_x, 		
	     fsm1_y        =>   fsm1_y, 		
	     fsm1_z        =>   fsm1_z, 		
	     fsm2_x        =>   fsm2_x, 		
	     fsm2_y        =>   fsm2_y, 		
	     fsm2_z        =>   fsm2_z, 		
	     fsm3_x        =>   fsm3_x, 		
	     fsm3_y        =>   fsm3_y, 		
	     fsm3_z        =>   fsm3_z, 		
	     loc_compute_done   =>    loc_compute_done, 
	     locator_clk   		=>    clk, 
	     locator_en    		=>    enable,  
	     locator_rst   		=>    reset, 

	     pixel_value   		=>    pixel_value, 
	     data_valid    		=>    pixel_valid,  
	     pixel_x       		=>     pixel_x,     
	     pixel_y       		=>     pixel_y,     
	     pixel_z       		=>     pixel_z     
	      );


	mac_control_dut: mac_control port map (
		pixel_value			             => pixel_value,
		mac_control_clk			         => clk,
		mac_control_reset	             => reset,
		mac_control_enable	             => enable,
		mac_control_stop	             => stop,
		pixel_x				             => pixel_x,
		pixel_y				             => pixel_y,
		pixel_z				             => pixel_z,
		pixel_valid			             => pixel_valid,
		stripe_status					 => stripe_status,
		address_done					 => address_done,

		control_kernel_address           => kernel_address,
		control_kernel_address_ready 	 => kernel_address_ready,
		control_pixel		             => control_pixel,
		control_pixel_valid				 => control_pixel_valid,
		control_x			             => control_x,
		control_y			             => control_y,
		control_z			             => control_z

		);

	mac_ccm_DUT: mac_ccm port map (    

     mac_kernel_value    => kernel_value,
     mac_kernel_valid    => kernel_valid,
     mac_pixel_value     => pixel_value,
     mac_pixel_valid     => control_pixel_valid,
     mac_clk             => clk,
     mac_reset           => reset,
     mac_enable          => enable,
     mac_x               => x,
     mac_y               => y,
     mac_z               => z,
     one_stripe_done     => one_stripe_done,

     compute_done_out    => compute_done_out, 
     output0             => output0,
     output1             => output1
      );

	sram_kernel_DUT: sram_kernel port map (    
		kernel_clk => clk, 
		kernel_reset => reset, 
		kernel_enable  => enable,   
		kernel_address  => kernel_address,

		kernel_data_valid  => kernel_data_valid,
		kernel_data => kernel_data 
      );


-----------------------------------------------------------
-- Clocks and Reset
-----------------------------------------------------------
	CLK_process : process

	begin
	  clk <= '0';
	  wait for tb_clk;
	  clk <= '1';
	  wait for tb_clk;	 
	end process;

--------------------------------------------------------------------------------
-- stimuli
--------------------------------------------------------------------------------

	process
	begin
		stripe_status  <= '0';
		one_stripe_done  <= 0;
		enable  <= '0';
		reset  <= '1';
		stop  <= '0';
		wait for 29  ns;
		reset  <= '0';
		--enable  <= '1';

		wait for 20 ns;

		enable   <= '1';
		wait for 21 ns;
     fsm0_data  <= 10; 
     fsm1_data  <= 1; 
     fsm2_data  <= 2; 
     fsm3_data  <= 3; 
     fsm0_valid  <= 1;
     fsm1_valid  <= 1;
     fsm2_valid  <= 1;
     fsm3_valid  <= 1;
     fsm0_x  <= 0;
     fsm0_y  <= 0;
     fsm0_z  <= 0;
     fsm1_x  <= 1;
     fsm1_y  <= 1;
     fsm1_z  <= 1;
     fsm2_x  <= 2;
     fsm2_y  <= 2;
     fsm2_z  <= 2;
     fsm3_x  <= 3;
     fsm3_y  <= 3;
     fsm3_z  <= 3;


    wait for 6000 ns;
    fsm0_data  <= 0; 
    fsm1_data  <= 1; 
    fsm2_data  <= 2; 
    fsm3_data  <= 3; 


    wait for 20 ns;
    fsm0_data  <= 0; 
    fsm1_data  <= 1; 
    fsm2_data  <= 2; 
    fsm3_data  <= 3; 


    wait for 60 ns;
    fsm0_data  <= 0; 
    fsm1_data  <= 1; 
    fsm2_data  <= 2; 
    fsm3_data  <= 3; 

    wait for 20 ns;
    fsm0_data  <= 0; 
    fsm1_data  <= 1; 
    fsm2_data  <= 2; 
    fsm3_data  <= 3; 


    wait for 80 ns;
    fsm0_data  <= 0; 
    fsm1_data  <= 1; 
    fsm2_data  <= 2; 
    fsm3_data  <= 3; 


    wait for 20 ns;
    fsm0_data  <= 0; 
    fsm1_data  <= 1; 
    fsm2_data  <= 2; 
    fsm3_data  <= 3; 


    wait for 60 ns;
    fsm0_data  <= 0; 
    fsm1_data  <= 1; 
    fsm2_data  <= 2; 
    fsm3_data  <= 3; 


    wait for 20 ns;
    fsm0_valid  <= 1;
    fsm1_valid  <= 0;
    fsm2_valid  <= 0;
    fsm3_valid  <= 0;

    wait for 20 ns; 
    fsm0_valid  <= 0;
    fsm1_valid  <= 1;
    fsm2_valid  <= 0;
    fsm3_valid  <= 0;

    wait for 20 ns; 
    fsm0_valid  <= 0;
    fsm1_valid  <= 0;
    fsm2_valid  <= 0;
    fsm3_valid  <= 0;
		

		wait;
		
	end process ;



end architecture testbench;